/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.allocator.NodeAllocationOrdering;
import org.elasticsearch.common.collect.Iterators;

public class OrderedShardsIterator
implements Iterator<ShardRouting> {
    private final ArrayDeque<NodeAndShardIterator> queue;

    public static OrderedShardsIterator create(RoutingNodes routingNodes, NodeAllocationOrdering ordering) {
        ArrayDeque<NodeAndShardIterator> queue = new ArrayDeque<NodeAndShardIterator>(routingNodes.size());
        for (String nodeId : ordering.sort(routingNodes.getAllNodeIds())) {
            RoutingNode node = routingNodes.node(nodeId);
            if (node.size() <= 0) continue;
            queue.add(new NodeAndShardIterator(nodeId, Iterators.forArray(node.copyShards())));
        }
        return new OrderedShardsIterator(queue);
    }

    private OrderedShardsIterator(ArrayDeque<NodeAndShardIterator> queue) {
        this.queue = queue;
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public ShardRouting next() {
        if (this.queue.isEmpty()) {
            throw new NoSuchElementException();
        }
        NodeAndShardIterator entry = this.queue.peek();
        assert (entry.iterator.hasNext());
        ShardRouting nextShard = entry.iterator.next();
        if (!entry.iterator.hasNext()) {
            this.queue.poll();
        }
        return nextShard;
    }

    public void dePrioritizeNode(String nodeId) {
        NodeAndShardIterator entry = this.queue.peek();
        if (entry != null && Objects.equals(nodeId, entry.nodeId)) {
            this.queue.offer(this.queue.poll());
        }
    }

    private record NodeAndShardIterator(String nodeId, Iterator<ShardRouting> iterator) {
    }
}

