/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.ModifyDataStreamsAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedBatchedClusterStateUpdateTask;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.SimpleBatchedAckListenerTaskExecutor;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAction;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataMigrateToDataStreamService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.IndicesService;

public class MetadataDataStreamsService {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final MasterServiceTaskQueue<UpdateLifecycleTask> taskQueue;

    public MetadataDataStreamsService(ClusterService clusterService, IndicesService indicesService) {
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        SimpleBatchedAckListenerTaskExecutor<UpdateLifecycleTask> executor = new SimpleBatchedAckListenerTaskExecutor<UpdateLifecycleTask>(){

            @Override
            public Tuple<ClusterState, ClusterStateAckListener> executeTask(UpdateLifecycleTask modifyLifecycleTask, ClusterState clusterState) {
                return new Tuple((Object)MetadataDataStreamsService.updateDataLifecycle(clusterState, modifyLifecycleTask.getDataStreamNames(), modifyLifecycleTask.getDataLifecycle()), (Object)modifyLifecycleTask);
            }
        };
        this.taskQueue = clusterService.createTaskQueue("modify-lifecycle", Priority.HIGH, executor);
    }

    public void modifyDataStream(final ModifyDataStreamsAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        if (request.getActions().size() == 0) {
            listener.onResponse(AcknowledgedResponse.TRUE);
        } else {
            this.submitUnbatchedTask("update-backing-indices", new AckedClusterStateUpdateTask(Priority.URGENT, request, listener){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    return MetadataDataStreamsService.modifyDataStream(currentState, request.getActions(), indexMetadata -> {
                        try {
                            return MetadataDataStreamsService.this.indicesService.createIndexMapperServiceForValidation((IndexMetadata)indexMetadata);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    });
                }
            });
        }
    }

    public void setLifecycle(List<String> dataStreamNames, DataStreamLifecycle lifecycle, TimeValue ackTimeout, TimeValue masterTimeout, ActionListener<AcknowledgedResponse> listener) {
        this.taskQueue.submitTask("set-lifecycle", new UpdateLifecycleTask(dataStreamNames, lifecycle, ackTimeout, listener), masterTimeout);
    }

    public void removeLifecycle(List<String> dataStreamNames, TimeValue ackTimeout, TimeValue masterTimeout, ActionListener<AcknowledgedResponse> listener) {
        this.taskQueue.submitTask("delete-lifecycle", new UpdateLifecycleTask(dataStreamNames, null, ackTimeout, listener), masterTimeout);
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    static ClusterState modifyDataStream(ClusterState currentState, Iterable<DataStreamAction> actions, Function<IndexMetadata, MapperService> mapperSupplier) {
        Metadata updatedMetadata = currentState.metadata();
        for (DataStreamAction action : actions) {
            Metadata.Builder builder = Metadata.builder(updatedMetadata);
            if (action.getType() == DataStreamAction.Type.ADD_BACKING_INDEX) {
                MetadataDataStreamsService.addBackingIndex(updatedMetadata, builder, mapperSupplier, action.getDataStream(), action.getIndex());
            } else if (action.getType() == DataStreamAction.Type.REMOVE_BACKING_INDEX) {
                MetadataDataStreamsService.removeBackingIndex(updatedMetadata, builder, action.getDataStream(), action.getIndex());
            } else {
                throw new IllegalStateException("unsupported data stream action type [" + action.getClass().getName() + "]");
            }
            updatedMetadata = builder.build();
        }
        return ClusterState.builder(currentState).metadata(updatedMetadata).build();
    }

    static ClusterState updateDataLifecycle(ClusterState currentState, List<String> dataStreamNames, @Nullable DataStreamLifecycle lifecycle) {
        Metadata metadata = currentState.metadata();
        Metadata.Builder builder = Metadata.builder(metadata);
        for (String dataStreamName : dataStreamNames) {
            DataStream dataStream = MetadataDataStreamsService.validateDataStream(metadata, dataStreamName);
            builder.put(new DataStream(dataStream.getName(), dataStream.getIndices(), dataStream.getGeneration(), dataStream.getMetadata(), dataStream.isHidden(), dataStream.isReplicated(), dataStream.isSystem(), dataStream.isAllowCustomRouting(), dataStream.getIndexMode(), lifecycle, dataStream.isFailureStore(), dataStream.getFailureIndices()));
        }
        return ClusterState.builder(currentState).metadata(builder.build()).build();
    }

    private static void addBackingIndex(Metadata metadata, Metadata.Builder builder, Function<IndexMetadata, MapperService> mapperSupplier, String dataStreamName, String indexName) {
        DataStream dataStream = MetadataDataStreamsService.validateDataStream(metadata, dataStreamName);
        IndexAbstraction index = MetadataDataStreamsService.validateIndex(metadata, indexName);
        try {
            MetadataMigrateToDataStreamService.prepareBackingIndex(builder, metadata.index(index.getWriteIndex()), dataStreamName, mapperSupplier, false);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to prepare backing index", e);
        }
        builder.put(dataStream.addBackingIndex(metadata, index.getWriteIndex()));
    }

    private static void removeBackingIndex(Metadata metadata, Metadata.Builder builder, String dataStreamName, String indexName) {
        boolean indexNotRemoved = true;
        DataStream dataStream = MetadataDataStreamsService.validateDataStream(metadata, dataStreamName);
        for (Index backingIndex : dataStream.getIndices()) {
            if (!backingIndex.getName().equals(indexName)) continue;
            builder.put(dataStream.removeBackingIndex(backingIndex));
            indexNotRemoved = false;
            break;
        }
        if (indexNotRemoved) {
            throw new IllegalArgumentException("index [" + indexName + "] not found");
        }
        IndexMetadata indexMetadata = builder.get(indexName);
        if (indexMetadata != null) {
            builder.put(IndexMetadata.builder(indexMetadata).settings(Settings.builder().put(indexMetadata.getSettings()).put("index.hidden", "false").build()).settingsVersion(indexMetadata.getSettingsVersion() + 1L));
        }
    }

    private static DataStream validateDataStream(Metadata metadata, String dataStreamName) {
        IndexAbstraction dataStream = (IndexAbstraction)metadata.getIndicesLookup().get(dataStreamName);
        if (dataStream == null || dataStream.getType() != IndexAbstraction.Type.DATA_STREAM) {
            throw new IllegalArgumentException("data stream [" + dataStreamName + "] not found");
        }
        return (DataStream)dataStream;
    }

    private static IndexAbstraction validateIndex(Metadata metadata, String indexName) {
        IndexAbstraction index = (IndexAbstraction)metadata.getIndicesLookup().get(indexName);
        if (index == null || index.getType() != IndexAbstraction.Type.CONCRETE_INDEX) {
            throw new IllegalArgumentException("index [" + indexName + "] not found");
        }
        return index;
    }

    static class UpdateLifecycleTask
    extends AckedBatchedClusterStateUpdateTask {
        private final List<String> dataStreamNames;
        private final DataStreamLifecycle lifecycle;

        UpdateLifecycleTask(List<String> dataStreamNames, @Nullable DataStreamLifecycle lifecycle, TimeValue ackTimeout, ActionListener<AcknowledgedResponse> listener) {
            super(ackTimeout, listener);
            this.dataStreamNames = dataStreamNames;
            this.lifecycle = lifecycle;
        }

        public List<String> getDataStreamNames() {
            return this.dataStreamNames;
        }

        public DataStreamLifecycle getDataLifecycle() {
            return this.lifecycle;
        }
    }
}

