/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ParseField;

public class BaseBroadcastResponse
extends ActionResponse {
    public static final DefaultShardOperationFailedException[] EMPTY = new DefaultShardOperationFailedException[0];
    private static final ParseField _SHARDS_FIELD = new ParseField("_shards", new String[0]);
    private static final ParseField TOTAL_FIELD = new ParseField("total", new String[0]);
    private static final ParseField SUCCESSFUL_FIELD = new ParseField("successful", new String[0]);
    private static final ParseField FAILED_FIELD = new ParseField("failed", new String[0]);
    private static final ParseField FAILURES_FIELD = new ParseField("failures", new String[0]);
    private final int totalShards;
    private final int successfulShards;
    private final int failedShards;
    private final DefaultShardOperationFailedException[] shardFailures;

    protected static <T extends BaseBroadcastResponse> void declareBroadcastFields(ConstructingObjectParser<T, Void> PARSER) {
        ConstructingObjectParser shardsParser = new ConstructingObjectParser("_shards", true, arg -> new BaseBroadcastResponse((Integer)arg[0], (Integer)arg[1], (Integer)arg[2], (List)arg[3]));
        shardsParser.declareInt(ConstructingObjectParser.constructorArg(), TOTAL_FIELD);
        shardsParser.declareInt(ConstructingObjectParser.constructorArg(), SUCCESSFUL_FIELD);
        shardsParser.declareInt(ConstructingObjectParser.constructorArg(), FAILED_FIELD);
        shardsParser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DefaultShardOperationFailedException.fromXContent(p), FAILURES_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (ContextParser)shardsParser, _SHARDS_FIELD);
    }

    public BaseBroadcastResponse(StreamInput in) throws IOException {
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        this.failedShards = in.readVInt();
        int size = in.readVInt();
        if (size > 0) {
            this.shardFailures = new DefaultShardOperationFailedException[size];
            for (int i = 0; i < size; ++i) {
                this.shardFailures[i] = DefaultShardOperationFailedException.readShardOperationFailed(in);
            }
        } else {
            this.shardFailures = EMPTY;
        }
    }

    public BaseBroadcastResponse(int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.failedShards = failedShards;
        this.shardFailures = shardFailures == null ? EMPTY : shardFailures.toArray(new DefaultShardOperationFailedException[shardFailures.size()]);
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int getFailedShards() {
        return this.failedShards;
    }

    public RestStatus getStatus() {
        if (this.failedShards > 0) {
            return this.shardFailures[0].status();
        }
        return RestStatus.OK;
    }

    public DefaultShardOperationFailedException[] getShardFailures() {
        return this.shardFailures;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.failedShards);
        out.writeArray(this.shardFailures);
    }
}

