/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.NodeClosedException;

public final class ActiveShardsObserver
extends Enum<ActiveShardsObserver> {
    private static final Logger logger;
    private static final /* synthetic */ ActiveShardsObserver[] $VALUES;

    public static ActiveShardsObserver[] values() {
        return (ActiveShardsObserver[])$VALUES.clone();
    }

    public static ActiveShardsObserver valueOf(String name) {
        return Enum.valueOf(ActiveShardsObserver.class, name);
    }

    public static void waitForActiveShards(final ClusterService clusterService, final String[] indexNames, ActiveShardCount activeShardCount, TimeValue timeout, final ActionListener<Boolean> listener) {
        if (activeShardCount == ActiveShardCount.NONE) {
            listener.onResponse(true);
            return;
        }
        ClusterState state = clusterService.state();
        if (activeShardCount.enoughShardsActive(state, indexNames)) {
            listener.onResponse(true);
            return;
        }
        new ClusterStateObserver(state, clusterService, null, logger, clusterService.threadPool().getThreadContext()).waitForNextChange(new ClusterStateObserver.Listener(){

            @Override
            public void onNewClusterState(ClusterState state1) {
                listener.onResponse(true);
            }

            @Override
            public void onClusterServiceClose() {
                logger.debug(() -> Strings.format((String)"[%s] cluster service closed while waiting for enough shards to be started.", (Object[])new Object[]{Arrays.toString(indexNames)}));
                listener.onFailure(new NodeClosedException(clusterService.localNode()));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                listener.onResponse(false);
            }
        }, newState -> activeShardCount.enoughShardsActive((ClusterState)newState, indexNames), timeout);
    }

    private static /* synthetic */ ActiveShardsObserver[] $values() {
        return new ActiveShardsObserver[0];
    }

    static {
        $VALUES = ActiveShardsObserver.$values();
        logger = LogManager.getLogger(ActiveShardsObserver.class);
    }
}

