/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.ClearScrollController;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportClearScrollAction
extends HandledTransportAction<ClearScrollRequest, ClearScrollResponse> {
    public static final String NAME = "indices:data/read/scroll/clear";
    public static final ActionType<ClearScrollResponse> TYPE = new ActionType<ClearScrollResponse>("indices:data/read/scroll/clear", ClearScrollResponse::new);
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;

    @Inject
    public TransportClearScrollAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, SearchTransportService searchTransportService) {
        super(TYPE.name(), transportService, actionFilters, ClearScrollRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.searchTransportService = searchTransportService;
    }

    @Override
    protected void doExecute(Task task, ClearScrollRequest request, ActionListener<ClearScrollResponse> listener) {
        ClearScrollController runnable = new ClearScrollController(request, listener, this.clusterService.state().nodes(), this.logger, this.searchTransportService);
        runnable.run();
    }
}

