/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class MaxPrimaryShardSizeCondition
extends Condition<ByteSizeValue> {
    public static final String NAME = "max_primary_shard_size";

    public MaxPrimaryShardSizeCondition(ByteSizeValue value) {
        super(NAME, Condition.Type.MAX);
        this.value = value;
    }

    public MaxPrimaryShardSizeCondition(StreamInput in) throws IOException {
        super(NAME, Condition.Type.MAX);
        this.value = ByteSizeValue.ofBytes(in.readVLong());
    }

    @Override
    public Condition.Result evaluate(Condition.Stats stats) {
        return new Condition.Result(this, stats.maxPrimaryShardSize().getBytes() >= ((ByteSizeValue)this.value).getBytes());
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(((ByteSizeValue)this.value).getBytes());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(NAME, ((ByteSizeValue)this.value).getStringRep());
    }

    public static MaxPrimaryShardSizeCondition fromXContent(XContentParser parser) throws IOException {
        if (parser.nextToken() == XContentParser.Token.VALUE_STRING) {
            return new MaxPrimaryShardSizeCondition(ByteSizeValue.parseBytesSizeValue(parser.text(), NAME));
        }
        throw new IllegalArgumentException("invalid token when parsing max_primary_shard_size condition: " + parser.currentToken());
    }
}

