/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.diskusage;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.diskusage.IndexDiskUsageStats;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class AnalyzeIndexDiskUsageResponse
extends BroadcastResponse {
    private final Map<String, IndexDiskUsageStats> stats;

    AnalyzeIndexDiskUsageResponse(int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures, Map<String, IndexDiskUsageStats> stats) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.stats = stats;
    }

    AnalyzeIndexDiskUsageResponse(StreamInput in) throws IOException {
        super(in);
        this.stats = in.readMap(IndexDiskUsageStats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.stats, StreamOutput::writeWriteable);
    }

    Map<String, IndexDiskUsageStats> getStats() {
        return this.stats;
    }

    @Override
    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        List entries = this.stats.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList();
        for (Map.Entry entry : entries) {
            builder.startObject((String)entry.getKey());
            ((IndexDiskUsageStats)entry.getValue()).toXContent(builder, params);
            builder.endObject();
        }
    }
}

