/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai.embeddings;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.openai.embeddings.OpenAiEmbeddingsRequestTaskSettings;

public record OpenAiEmbeddingsTaskSettings(String model, @Nullable String user) implements TaskSettings
{
    public static final String NAME = "openai_embeddings_task_settings";
    public static final String MODEL = "model";
    public static final String USER = "user";

    public OpenAiEmbeddingsTaskSettings {
        Objects.requireNonNull(model);
    }

    public OpenAiEmbeddingsTaskSettings(StreamInput in) throws IOException {
        this(in.readString(), in.readOptionalString());
    }

    public static OpenAiEmbeddingsTaskSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        String model = ServiceUtils.extractRequiredString(map, MODEL, "task_settings", validationException);
        String user = ServiceUtils.extractOptionalString(map, USER, "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new OpenAiEmbeddingsTaskSettings(model, user);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL, this.model);
        if (this.user != null) {
            builder.field(USER, this.user);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_OPENAI_ADDED;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.model);
        out.writeOptionalString(this.user);
    }

    public OpenAiEmbeddingsTaskSettings overrideWith(OpenAiEmbeddingsRequestTaskSettings requestSettings) {
        String modelToUse = requestSettings.model() == null ? this.model : requestSettings.model();
        String userToUse = requestSettings.user() == null ? this.user : requestSettings.user();
        return new OpenAiEmbeddingsTaskSettings(modelToUse, userToUse);
    }
}

