/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai.embeddings;

import java.util.Map;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public record OpenAiEmbeddingsRequestTaskSettings(String model, String user) {
    public static final OpenAiEmbeddingsRequestTaskSettings EMPTY_SETTINGS = new OpenAiEmbeddingsRequestTaskSettings(null, null);

    public static OpenAiEmbeddingsRequestTaskSettings fromMap(Map<String, Object> map) {
        if (map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        ValidationException validationException = new ValidationException();
        String model = ServiceUtils.extractOptionalString(map, "model", "task_settings", validationException);
        String user = ServiceUtils.extractOptionalString(map, "user", "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new OpenAiEmbeddingsRequestTaskSettings(model, user);
    }
}

