/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.huggingface;

import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.RetrySettings;
import org.elasticsearch.xpack.inference.external.http.retry.RetryingHttpSender;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.huggingface.HuggingFaceAccount;
import org.elasticsearch.xpack.inference.external.request.huggingface.HuggingFaceInferenceRequest;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceModel;

public class HuggingFaceAction
implements ExecutableAction {
    private static final Logger logger = LogManager.getLogger(HuggingFaceAction.class);
    private final HuggingFaceAccount account;
    private final String errorMessage;
    private final RetryingHttpSender sender;
    private final ResponseHandler responseHandler;
    private final Truncator truncator;
    private final Integer tokenLimit;

    public HuggingFaceAction(Sender sender, HuggingFaceModel model, ServiceComponents serviceComponents, ResponseHandler responseHandler, String requestType) {
        Objects.requireNonNull(serviceComponents);
        Objects.requireNonNull(model);
        Objects.requireNonNull(requestType);
        this.responseHandler = Objects.requireNonNull(responseHandler);
        this.sender = new RetryingHttpSender(Objects.requireNonNull(sender), serviceComponents.throttlerManager(), logger, new RetrySettings(serviceComponents.settings()), serviceComponents.threadPool());
        this.account = new HuggingFaceAccount(model.getUri(), model.getApiKey());
        this.errorMessage = Strings.format((String)"Failed to send Hugging Face %s request to [%s]", (Object[])new Object[]{requestType, model.getUri().toString()});
        this.truncator = Objects.requireNonNull(serviceComponents.truncator());
        this.tokenLimit = model.getTokenLimit();
    }

    @Override
    public void execute(List<String> input, ActionListener<InferenceServiceResults> listener) {
        try {
            Truncator.TruncationResult truncatedInput = Truncator.truncate(input, this.tokenLimit);
            HuggingFaceInferenceRequest request = new HuggingFaceInferenceRequest(this.truncator, this.account, truncatedInput);
            ActionListener<InferenceServiceResults> wrappedListener = ActionUtils.wrapFailuresInElasticsearchException(this.errorMessage, listener);
            this.sender.send(request, this.responseHandler, wrappedListener);
        }
        catch (ElasticsearchException e) {
            listener.onFailure((Exception)((Object)e));
        }
        catch (Exception e) {
            listener.onFailure((Exception)ActionUtils.createInternalServerError(e, this.errorMessage));
        }
    }
}

