/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.core.inference.results.LegacyTextEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.SparseEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingResults;
import org.elasticsearch.xpack.inference.services.elser.ElserMlNodeServiceSettings;
import org.elasticsearch.xpack.inference.services.elser.ElserMlNodeTaskSettings;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceServiceSettings;
import org.elasticsearch.xpack.inference.services.huggingface.elser.HuggingFaceElserSecretSettings;
import org.elasticsearch.xpack.inference.services.huggingface.elser.HuggingFaceElserServiceSettings;
import org.elasticsearch.xpack.inference.services.openai.OpenAiServiceSettings;
import org.elasticsearch.xpack.inference.services.openai.embeddings.OpenAiEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class InferenceNamedWriteablesProvider {
    private InferenceNamedWriteablesProvider() {
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceResults.class, "text_embedding_results", LegacyTextEmbeddingResults::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceServiceResults.class, "sparse_embedding_results", SparseEmbeddingResults::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceServiceResults.class, "text_embedding_service_results", TextEmbeddingResults::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "empty_task_settings", EmptyTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(SecretSettings.class, "default_secret_settings", DefaultSecretSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "elser_mlnode_service_settings", ElserMlNodeServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "elser_mlnode_task_settings", ElserMlNodeTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "hugging_face_elser_service_settings", HuggingFaceElserServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "hugging_face_service_settings", HuggingFaceServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(SecretSettings.class, "hugging_face_elser_secret_settings", HuggingFaceElserSecretSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "openai_service_settings", OpenAiServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "openai_embeddings_task_settings", OpenAiEmbeddingsTaskSettings::new));
        return namedWriteables;
    }
}

