/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.rules.QueryRule;
import org.elasticsearch.xpack.application.rules.QueryRuleset;

public class GetQueryRulesetAction
extends ActionType<Response> {
    public static final GetQueryRulesetAction INSTANCE = new GetQueryRulesetAction();
    public static final String NAME = "cluster:admin/xpack/query_rules/get";

    private GetQueryRulesetAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final QueryRuleset queryRuleset;
        private static final ParseField QUERY_RULESET_FIELD = new ParseField("queryRuleset", new String[0]);
        private static final ConstructingObjectParser<Response, String> PARSER = new ConstructingObjectParser("get_query_ruleset_response", p -> new Response((QueryRuleset)p[0]));

        public Response(StreamInput in) throws IOException {
            super(in);
            this.queryRuleset = new QueryRuleset(in);
        }

        public Response(QueryRuleset queryRuleset) {
            this.queryRuleset = queryRuleset;
        }

        public Response(String rulesetId, List<QueryRule> rules) {
            this.queryRuleset = new QueryRuleset(rulesetId, rules);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.queryRuleset.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.queryRuleset.toXContent(builder, params);
        }

        public QueryRuleset queryRuleset() {
            return this.queryRuleset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.queryRuleset, response.queryRuleset);
        }

        public int hashCode() {
            return Objects.hash(this.queryRuleset);
        }

        public static Response fromXContent(String resourceName, XContentParser parser) throws IOException {
            return new Response(QueryRuleset.fromXContent(resourceName, parser));
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> QueryRuleset.fromXContent(c, p), QUERY_RULESET_FIELD);
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        private final String rulesetId;
        private static final ParseField RULESET_ID_FIELD = new ParseField("ruleset_id", new String[0]);
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("get_query_ruleset_request", false, p -> new Request((String)p[0]));

        public Request(StreamInput in) throws IOException {
            super(in);
            this.rulesetId = in.readString();
        }

        public Request(String rulesetId) {
            this.rulesetId = rulesetId;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.rulesetId)) {
                validationException = ValidateActions.addValidationError((String)"ruleset_id missing", validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.rulesetId);
        }

        public String rulesetId() {
            return this.rulesetId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.rulesetId, request.rulesetId);
        }

        public int hashCode() {
            return Objects.hash(this.rulesetId);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(RULESET_ID_FIELD.getPreferredName(), this.rulesetId);
            builder.endObject();
            return builder;
        }

        public static Request parse(XContentParser parser, String name) {
            return (Request)((Object)PARSER.apply(parser, (Object)name));
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), RULESET_ID_FIELD);
        }
    }
}

