/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;

public class UpdateConnectorLastSeenAction
extends ActionType<ConnectorUpdateActionResponse> {
    public static final UpdateConnectorLastSeenAction INSTANCE = new UpdateConnectorLastSeenAction();
    public static final String NAME = "cluster:admin/xpack/connector/update_last_seen";

    public UpdateConnectorLastSeenAction() {
        super(NAME, ConnectorUpdateActionResponse::new);
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        private final String connectorId;
        private final Instant lastSeen;

        public Request(String connectorId) {
            this.connectorId = connectorId;
            this.lastSeen = Instant.now();
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
            this.lastSeen = in.readInstant();
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_id] cannot be null or empty.", validationException);
            }
            return validationException;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Connector.LAST_SEEN_FIELD.getPreferredName(), (Object)this.lastSeen);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
            out.writeInstant(this.lastSeen);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorId, request.connectorId) && Objects.equals(this.lastSeen, request.lastSeen);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.lastSeen);
        }
    }
}

