/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.ConnectorFiltering;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;

public class UpdateConnectorFilteringAction
extends ActionType<ConnectorUpdateActionResponse> {
    public static final UpdateConnectorFilteringAction INSTANCE = new UpdateConnectorFilteringAction();
    public static final String NAME = "cluster:admin/xpack/connector/update_filtering";

    public UpdateConnectorFilteringAction() {
        super(NAME, ConnectorUpdateActionResponse::new);
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        private final String connectorId;
        private final List<ConnectorFiltering> filtering;
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("connector_update_filtering_request", false, (args, connectorId) -> new Request((String)connectorId, (List)args[0]));

        public Request(String connectorId, List<ConnectorFiltering> filtering) {
            this.connectorId = connectorId;
            this.filtering = filtering;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
            this.filtering = in.readOptionalCollectionAsList(ConnectorFiltering::new);
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public List<ConnectorFiltering> getFiltering() {
            return this.filtering;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_id] cannot be null or empty.", validationException);
            }
            if (this.filtering == null) {
                validationException = ValidateActions.addValidationError((String)"[filtering] cannot be null.", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public static Request fromXContentBytes(String connectorId, BytesReference source, XContentType xContentType) {
            Request request;
            block8: {
                XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
                try {
                    request = Request.fromXContent(parser, connectorId);
                    if (parser == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ElasticsearchParseException("Failed to parse: " + source.utf8ToString(), (Throwable)e, new Object[0]);
                    }
                }
                parser.close();
            }
            return request;
        }

        public static Request fromXContent(XContentParser parser, String connectorId) throws IOException {
            return (Request)((Object)PARSER.parse(parser, (Object)connectorId));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Connector.FILTERING_FIELD.getPreferredName(), this.filtering);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
            out.writeOptionalCollection(this.filtering);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorId, request.connectorId) && Objects.equals(this.filtering, request.filtering);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.filtering);
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> ConnectorFiltering.fromXContent(p), Connector.FILTERING_FIELD);
        }
    }
}

