/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.analytics;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.IngestPipelineConfig;
import org.elasticsearch.xpack.core.template.JsonIngestPipelineConfig;

public class AnalyticsTemplateRegistry
extends IndexTemplateRegistry {
    public static final NodeFeature ANALYTICS_TEMPLATE_FEATURE = new NodeFeature("behavioral_analytics.templates");
    static final int REGISTRY_VERSION = 3;
    static final String EVENT_DATA_STREAM_SETTINGS_COMPONENT_NAME = "behavioral_analytics-events-settings";
    static final String EVENT_DATA_STREAM_MAPPINGS_COMPONENT_NAME = "behavioral_analytics-events-mappings";
    static final String EVENT_DATA_STREAM_INGEST_PIPELINE_NAME = "behavioral_analytics-events-final_pipeline";
    static final Map<String, ComponentTemplate> COMPONENT_TEMPLATES;
    static final String EVENT_DATA_STREAM_TEMPLATE_NAME = "behavioral_analytics-events-default";
    static final String EVENT_DATA_STREAM_TEMPLATE_FILENAME = "behavioral_analytics-events-template";
    static final Map<String, ComposableIndexTemplate> COMPOSABLE_INDEX_TEMPLATES;
    private final FeatureService featureService;

    protected List<IngestPipelineConfig> getIngestPipelines() {
        return List.of(new JsonIngestPipelineConfig(EVENT_DATA_STREAM_INGEST_PIPELINE_NAME, "/entsearch/analytics/behavioral_analytics-events-final_pipeline.json", 3, "xpack.entsearch.analytics.template.version"));
    }

    public AnalyticsTemplateRegistry(ClusterService clusterService, FeatureService featureService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(Settings.EMPTY, clusterService, threadPool, client, xContentRegistry);
        this.featureService = featureService;
    }

    protected String getOrigin() {
        return "enterprise_search";
    }

    protected Map<String, ComponentTemplate> getComponentTemplateConfigs() {
        return COMPONENT_TEMPLATES;
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        return COMPOSABLE_INDEX_TEMPLATES;
    }

    protected boolean requiresMasterNode() {
        return true;
    }

    protected boolean isClusterReady(ClusterChangedEvent event) {
        return this.featureService.clusterHasFeature(event.state(), ANALYTICS_TEMPLATE_FEATURE);
    }

    static {
        HashMap<String, ComponentTemplate> componentTemplates = new HashMap<String, ComponentTemplate>();
        for (IndexTemplateConfig config : List.of(new IndexTemplateConfig(EVENT_DATA_STREAM_SETTINGS_COMPONENT_NAME, "/entsearch/analytics/behavioral_analytics-events-settings.json", 3, "xpack.entsearch.analytics.template.version"), new IndexTemplateConfig(EVENT_DATA_STREAM_MAPPINGS_COMPONENT_NAME, "/entsearch/analytics/behavioral_analytics-events-mappings.json", 3, "xpack.entsearch.analytics.template.version"))) {
            try {
                componentTemplates.put(config.getTemplateName(), ComponentTemplate.parse((XContentParser)JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, config.loadBytes())));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        COMPONENT_TEMPLATES = Map.copyOf(componentTemplates);
        COMPOSABLE_INDEX_TEMPLATES = AnalyticsTemplateRegistry.parseComposableTemplates((IndexTemplateConfig[])new IndexTemplateConfig[]{new IndexTemplateConfig(EVENT_DATA_STREAM_TEMPLATE_NAME, "/entsearch/analytics/behavioral_analytics-events-template.json", 3, "xpack.entsearch.analytics.template.version", Map.of("event_data_stream.index_pattern", "behavioral_analytics-events-*"))});
    }
}

