/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.bucket.adjacency;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.aggregations.bucket.adjacency.AdjacencyMatrix;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.search.aggregations.ParsedMultiBucketAggregation;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.XContentParser;

public class ParsedAdjacencyMatrix
extends ParsedMultiBucketAggregation<ParsedBucket>
implements AdjacencyMatrix {
    private Map<String, ParsedBucket> bucketMap;
    private static final ObjectParser<ParsedAdjacencyMatrix, Void> PARSER = new ObjectParser(ParsedAdjacencyMatrix.class.getSimpleName(), true, ParsedAdjacencyMatrix::new);

    public String getType() {
        return "adjacency_matrix";
    }

    @Override
    public List<? extends AdjacencyMatrix.Bucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public ParsedBucket getBucketByKey(String key) {
        if (this.bucketMap == null) {
            this.bucketMap = Maps.newMapWithExpectedSize((int)this.buckets.size());
            for (ParsedBucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKey(), bucket);
            }
        }
        return this.bucketMap.get(key);
    }

    public static ParsedAdjacencyMatrix fromXContent(XContentParser parser, String name) throws IOException {
        ParsedAdjacencyMatrix aggregation = (ParsedAdjacencyMatrix)PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedAdjacencyMatrix.declareMultiBucketAggregationFields(PARSER, ParsedBucket::fromXContent, ParsedBucket::fromXContent);
    }

    public static class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements AdjacencyMatrix.Bucket {
        private String key;

        public String getKey() {
            return this.key;
        }

        public String getKeyAsString() {
            return this.key;
        }

        static ParsedBucket fromXContent(XContentParser parser) throws IOException {
            return (ParsedBucket)ParsedBucket.parseXContent((XContentParser)parser, (boolean)false, ParsedBucket::new, (p, bucket) -> {
                bucket.key = p.text();
            });
        }
    }
}

