/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.CIDRMatchFunctionProcessor;
import org.elasticsearch.xpack.ql.execution.search.QlSourceBuilder;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public class CIDRMatchFunctionPipe
extends Pipe {
    private final Pipe input;
    private final List<Pipe> addresses;

    public CIDRMatchFunctionPipe(Source source, Expression expression, Pipe input, List<Pipe> addresses) {
        super(source, expression, CollectionUtils.combine(Collections.singletonList(input), addresses));
        this.input = input;
        this.addresses = addresses;
    }

    public final Pipe replaceChildren(List<Pipe> newChildren) {
        return this.replaceChildren(newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    public final Pipe resolveAttributes(Pipe.AttributeResolver resolver) {
        Pipe newInput = this.input.resolveAttributes(resolver);
        boolean same = newInput == this.input;
        ArrayList<Pipe> newAddresses = new ArrayList<Pipe>(this.addresses.size());
        for (Pipe address : this.addresses) {
            Pipe newAddress = address.resolveAttributes(resolver);
            newAddresses.add(newAddress);
            same = same && address == newAddress;
        }
        return same ? this : this.replaceChildren(newInput, newAddresses);
    }

    public boolean supportedByAggsOnlyQuery() {
        if (!this.input.supportedByAggsOnlyQuery()) {
            return false;
        }
        for (Pipe address : this.addresses) {
            if (address.supportedByAggsOnlyQuery()) continue;
            return false;
        }
        return true;
    }

    public boolean resolved() {
        if (!this.input.resolved()) {
            return false;
        }
        for (Pipe address : this.addresses) {
            if (address.resolved()) continue;
            return false;
        }
        return true;
    }

    protected CIDRMatchFunctionPipe replaceChildren(Pipe newInput, List<Pipe> newAddresses) {
        return new CIDRMatchFunctionPipe(this.source(), this.expression(), newInput, newAddresses);
    }

    public final void collectFields(QlSourceBuilder sourceBuilder) {
        this.input.collectFields(sourceBuilder);
        for (Pipe address : this.addresses) {
            address.collectFields(sourceBuilder);
        }
    }

    protected NodeInfo<CIDRMatchFunctionPipe> info() {
        return NodeInfo.create((Node)this, CIDRMatchFunctionPipe::new, (Object)this.expression(), (Object)this.input, this.addresses);
    }

    public CIDRMatchFunctionProcessor asProcessor() {
        ArrayList<Processor> processors = new ArrayList<Processor>(this.addresses.size());
        for (Pipe address : this.addresses) {
            processors.add(address.asProcessor());
        }
        return new CIDRMatchFunctionProcessor(this.input.asProcessor(), processors);
    }

    public Pipe input() {
        return this.input;
    }

    public List<Pipe> addresses() {
        return this.addresses;
    }

    public int hashCode() {
        return Objects.hash(this.input(), this.addresses());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CIDRMatchFunctionPipe other = (CIDRMatchFunctionPipe)((Object)obj);
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.addresses(), other.addresses());
    }
}

