/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.matrix.decomposition.LDLDecomposition;
import org.ojalgo.matrix.decomposition.LDU;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.context.NumberContext;

public interface LDL<N extends Comparable<N>>
extends LDU<N>,
MatrixDecomposition.Hermitian<N>,
MatrixDecomposition.Pivoting<N> {
    public static final Factory<ComplexNumber> COMPLEX = typical -> new LDLDecomposition.Complex();
    public static final Factory<Double> PRIMITIVE = typical -> new LDLDecomposition.Primitive();
    public static final Factory<Quaternion> QUATERNION = typical -> new LDLDecomposition.Quat();
    public static final Factory<RationalNumber> RATIONAL = typical -> new LDLDecomposition.Rational();

    public static <N extends Comparable<N>> boolean equals(MatrixStore<N> matrix, LDL<N> decomposition, NumberContext context) {
        return Access2D.equals(matrix, decomposition.reconstruct(), context);
    }

    public MatrixStore<N> getD();

    default public MatrixStore<N> getL() {
        return this.getR().conjugate();
    }

    default public MatrixStore<N> getR() {
        return this.getL().conjugate();
    }

    @Override
    default public MatrixStore<N> reconstruct() {
        MatrixStore<MatrixStore<N>> mtrxL = this.getL();
        MatrixStore<N> mtrxD = this.getD();
        MatrixStore<N> mtrxR = this.getR();
        int[] pivotOrder = this.getPivotOrder();
        return (MatrixStore)((MatrixStore)mtrxL.multiply(mtrxD).multiply((MatrixStore<MatrixStore<N>>)mtrxR).row(pivotOrder)).column(pivotOrder);
    }

    public static interface Factory<N extends Comparable<N>>
    extends MatrixDecomposition.Factory<LDL<N>> {
    }
}

