/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import com.azure.core.util.serializer.JacksonAdapter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ReloadablePlugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.azure.AzureClientProvider;
import org.elasticsearch.repositories.azure.AzureRepository;
import org.elasticsearch.repositories.azure.AzureStorageService;
import org.elasticsearch.repositories.azure.AzureStorageSettings;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ScalingExecutorBuilder;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class AzureRepositoryPlugin
extends Plugin
implements RepositoryPlugin,
ReloadablePlugin {
    public static final String REPOSITORY_THREAD_POOL_NAME = "repository_azure";
    public static final String NETTY_EVENT_LOOP_THREAD_POOL_NAME = "azure_event_loop";
    final SetOnce<AzureStorageService> azureStoreService = new SetOnce();
    private final Settings settings;

    public AzureRepositoryPlugin(Settings settings) {
        AzureStorageSettings.load(settings);
        this.settings = settings;
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings) {
        return Collections.singletonMap("azure", metadata -> {
            AzureStorageService storageService = (AzureStorageService)this.azureStoreService.get();
            assert (storageService != null);
            return new AzureRepository(metadata, namedXContentRegistry, storageService, clusterService, bigArrays, recoverySettings);
        });
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        AzureClientProvider azureClientProvider = AzureClientProvider.create(services.threadPool(), this.settings);
        this.azureStoreService.set((Object)this.createAzureStorageService(this.settings, azureClientProvider));
        return List.of(azureClientProvider);
    }

    AzureStorageService createAzureStorageService(Settings settingsToUse, AzureClientProvider azureClientProvider) {
        return new AzureStorageService(settingsToUse, azureClientProvider);
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(AzureStorageSettings.ACCOUNT_SETTING, AzureStorageSettings.KEY_SETTING, AzureStorageSettings.SAS_TOKEN_SETTING, AzureStorageSettings.ENDPOINT_SUFFIX_SETTING, AzureStorageSettings.TIMEOUT_SETTING, AzureStorageSettings.MAX_RETRIES_SETTING, AzureStorageSettings.PROXY_TYPE_SETTING, AzureStorageSettings.PROXY_HOST_SETTING, AzureStorageSettings.PROXY_PORT_SETTING, AzureStorageSettings.ENDPOINT_SETTING, AzureStorageSettings.SECONDARY_ENDPOINT_SETTING);
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settingsToUse) {
        return List.of(AzureRepositoryPlugin.executorBuilder(), AzureRepositoryPlugin.nettyEventLoopExecutorBuilder(settingsToUse));
    }

    public static ExecutorBuilder<?> executorBuilder() {
        return new ScalingExecutorBuilder(REPOSITORY_THREAD_POOL_NAME, 0, 5, TimeValue.timeValueSeconds((long)30L), false);
    }

    public static ExecutorBuilder<?> nettyEventLoopExecutorBuilder(Settings settings) {
        int eventLoopThreads = AzureClientProvider.eventLoopThreadsFromSettings(settings);
        return new ScalingExecutorBuilder(NETTY_EVENT_LOOP_THREAD_POOL_NAME, 0, eventLoopThreads, TimeValue.timeValueSeconds((long)30L), false);
    }

    public void reload(Settings settingsToLoad) {
        Map<String, AzureStorageSettings> clientsSettings = AzureStorageSettings.load(settingsToLoad);
        AzureStorageService storageService = (AzureStorageService)this.azureStoreService.get();
        assert (storageService != null);
        storageService.refreshSettings(clientsSettings);
    }

    static {
        JacksonAdapter.createDefaultSerializerAdapter();
    }
}

