/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;

public final class LeakTracker {
    private static final Logger logger = LogManager.getLogger(LeakTracker.class);
    private static final int TARGET_RECORDS = 25;
    private final Set<Leak<?>> allLeaks = ConcurrentCollections.newConcurrentSet();
    private final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private final ConcurrentMap<String, Boolean> reportedLeaks = ConcurrentCollections.newConcurrentMap();
    public static final LeakTracker INSTANCE = new LeakTracker();

    private LeakTracker() {
    }

    public <T> Leak<T> track(T obj) {
        this.reportLeak();
        return new Leak(obj, this.refQueue, this.allLeaks);
    }

    public void reportLeak() {
        Leak ref;
        while ((ref = (Leak)this.refQueue.poll()) != null) {
            String records;
            if (!ref.dispose() || !logger.isErrorEnabled() || this.reportedLeaks.putIfAbsent(records = ref.toString(), Boolean.TRUE) != null) continue;
            logger.error("LEAK: resource was not cleaned up before it was garbage-collected.{}", (Object)records);
        }
    }

    public static Releasable wrap(Releasable releasable) {
        if (!Assertions.ENABLED) {
            return releasable;
        }
        Leak<Releasable> leak = INSTANCE.track(releasable);
        return () -> {
            try {
                releasable.close();
            }
            finally {
                leak.close(releasable);
            }
        };
    }

    public static RefCounted wrap(final RefCounted refCounted) {
        if (!Assertions.ENABLED) {
            return refCounted;
        }
        final Leak<RefCounted> leak = INSTANCE.track(refCounted);
        return new RefCounted(){

            public void incRef() {
                leak.record();
                refCounted.incRef();
            }

            public boolean tryIncRef() {
                leak.record();
                return refCounted.tryIncRef();
            }

            public boolean decRef() {
                if (refCounted.decRef()) {
                    leak.close(refCounted);
                    return true;
                }
                leak.record();
                return false;
            }

            public boolean hasReferences() {
                return refCounted.hasReferences();
            }
        };
    }

    public static final class Leak<T>
    extends WeakReference<Object> {
        private static final AtomicReferenceFieldUpdater<Leak<?>, Record> headUpdater = AtomicReferenceFieldUpdater.newUpdater(Leak.class, Record.class, "head");
        private static final AtomicIntegerFieldUpdater<Leak<?>> droppedRecordsUpdater = AtomicIntegerFieldUpdater.newUpdater(Leak.class, "droppedRecords");
        private volatile Record head;
        private volatile int droppedRecords;
        private final Set<Leak<?>> allLeaks;
        private final int trackedHash;

        private Leak(Object referent, ReferenceQueue<Object> refQueue, Set<Leak<?>> allLeaks) {
            super(referent, refQueue);
            assert (referent != null);
            this.trackedHash = System.identityHashCode(referent);
            allLeaks.add(this);
            headUpdater.set(this, new Record(Record.BOTTOM));
            this.allLeaks = allLeaks;
        }

        public void record() {
            boolean dropped;
            Record prevHead;
            Record newHead;
            Record oldHead;
            do {
                prevHead = oldHead = headUpdater.get(this);
                if (oldHead == null) {
                    return;
                }
                int numElements = oldHead.pos + 1;
                if (numElements >= 25) {
                    int backOffFactor = Math.min(numElements - 25, 30);
                    dropped = Randomness.get().nextInt(1 << backOffFactor) != 0;
                    if (!dropped) continue;
                    prevHead = oldHead.next;
                    continue;
                }
                dropped = false;
            } while (!headUpdater.compareAndSet(this, oldHead, newHead = new Record(prevHead)));
            if (dropped) {
                droppedRecordsUpdater.incrementAndGet(this);
            }
        }

        private boolean dispose() {
            this.clear();
            return this.allLeaks.remove(this);
        }

        public boolean close(T trackedObject) {
            assert (this.trackedHash == System.identityHashCode(trackedObject));
            try {
                if (this.allLeaks.remove(this)) {
                    this.clear();
                    headUpdater.set(this, null);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                Leak.reachabilityFence0(trackedObject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void reachabilityFence0(Object ref) {
            if (ref != null) {
                Object object = ref;
                synchronized (object) {
                }
            }
        }

        public String toString() {
            Record oldHead = headUpdater.get(this);
            if (oldHead == null) {
                return "";
            }
            int dropped = droppedRecordsUpdater.get(this);
            int duped = 0;
            int present = oldHead.pos + 1;
            StringBuilder buf = new StringBuilder(present * 2048).append('\n');
            buf.append("Recent access records: ").append('\n');
            int i = 1;
            Set<String> seen = Sets.newHashSetWithExpectedSize(present);
            while (oldHead != Record.BOTTOM) {
                String s = oldHead.toString();
                if (seen.add(s)) {
                    if (oldHead.next == Record.BOTTOM) {
                        buf.append("Created at:").append('\n').append(s);
                    } else {
                        buf.append('#').append(i++).append(':').append('\n').append(s);
                    }
                } else {
                    ++duped;
                }
                oldHead = oldHead.next;
            }
            if (duped > 0) {
                buf.append(": ").append(duped).append(" leak records were discarded because they were duplicates").append('\n');
            }
            if (dropped > 0) {
                buf.append(": ").append(dropped).append(" leak records were discarded because the leak record count is targeted to ").append(25).append('.').append('\n');
            }
            buf.setLength(buf.length() - "\n".length());
            return buf.toString();
        }
    }

    private static final class Record
    extends Throwable {
        private static final Record BOTTOM = new Record();
        private final Record next;
        private final int pos;

        Record(Record next) {
            this.next = next;
            this.pos = next.pos + 1;
        }

        private Record() {
            this.next = null;
            this.pos = -1;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            StackTraceElement[] array = this.getStackTrace();
            for (int i = 3; i < array.length; ++i) {
                StackTraceElement element = array[i];
                buf.append('\t');
                buf.append(element.toString());
                buf.append('\n');
            }
            return buf.toString();
        }
    }
}

