/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.health.Diagnosis;
import org.elasticsearch.health.HealthIndicatorDetails;
import org.elasticsearch.health.HealthIndicatorImpact;
import org.elasticsearch.health.HealthIndicatorResult;
import org.elasticsearch.health.HealthIndicatorService;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.health.ImpactArea;
import org.elasticsearch.health.SimpleHealthIndicatorDetails;
import org.elasticsearch.health.node.HealthInfo;

public class RepositoryIntegrityHealthIndicatorService
implements HealthIndicatorService {
    public static final String NAME = "repository_integrity";
    public static final String HELP_URL = "https://ela.st/fix-repository-integrity";
    public static final String REPOSITORY_CORRUPTED_IMPACT_ID = "repository_corruption";
    public static final Diagnosis.Definition CORRUPTED_REPOSITORY = new Diagnosis.Definition("repository_integrity", "corrupt_repo_integrity", "Multiple clusters are writing to the same repository.", "Remove the repository from the other cluster(s), or mark it as read-only in the other cluster(s), and then re-add the repository to this cluster.", "https://ela.st/fix-repository-integrity");
    public static final String NO_REPOS_CONFIGURED = "No snapshot repositories configured.";
    public static final String NO_CORRUPT_REPOS = "No corrupted snapshot repositories.";
    private final ClusterService clusterService;

    public RepositoryIntegrityHealthIndicatorService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public HealthIndicatorResult calculate(boolean verbose, int maxAffectedResourcesCount, HealthInfo healthInfo) {
        RepositoriesMetadata snapshotMetadata = RepositoriesMetadata.get(this.clusterService.state());
        if (snapshotMetadata.repositories().isEmpty()) {
            return this.createIndicator(HealthStatus.GREEN, NO_REPOS_CONFIGURED, HealthIndicatorDetails.EMPTY, Collections.emptyList(), Collections.emptyList());
        }
        List<String> corrupted = snapshotMetadata.repositories().stream().filter(repository -> repository.generation() == -3L).map(RepositoryMetadata::name).toList();
        int totalRepositories = snapshotMetadata.repositories().size();
        int corruptedRepositories = corrupted.size();
        if (corrupted.isEmpty()) {
            return this.createIndicator(HealthStatus.GREEN, NO_CORRUPT_REPOS, verbose ? new SimpleHealthIndicatorDetails(Map.of("total_repositories", totalRepositories)) : HealthIndicatorDetails.EMPTY, Collections.emptyList(), Collections.emptyList());
        }
        List<HealthIndicatorImpact> impacts = Collections.singletonList(new HealthIndicatorImpact(NAME, REPOSITORY_CORRUPTED_IMPACT_ID, 1, String.format(Locale.ROOT, "Data in corrupted snapshot repositor%s %s may be lost and cannot be restored.", corrupted.size() > 1 ? "ies" : "y", CollectionUtils.limitSize(corrupted, 10)), List.of(ImpactArea.BACKUP)));
        return this.createIndicator(HealthStatus.RED, RepositoryIntegrityHealthIndicatorService.createCorruptedRepositorySummary(corrupted), verbose ? new SimpleHealthIndicatorDetails(Map.of("total_repositories", totalRepositories, "corrupted_repositories", corruptedRepositories, "corrupted", CollectionUtils.limitSize(corrupted, 10))) : HealthIndicatorDetails.EMPTY, impacts, List.of(new Diagnosis(CORRUPTED_REPOSITORY, List.of(new Diagnosis.Resource(Diagnosis.Resource.Type.SNAPSHOT_REPOSITORY, CollectionUtils.limitSize(corrupted, maxAffectedResourcesCount))))));
    }

    private static String createCorruptedRepositorySummary(List<String> corrupted) {
        StringBuilder message = new StringBuilder().append("Detected [").append(corrupted.size()).append("] corrupted snapshot repositories: ");
        Strings.collectionToDelimitedStringWithLimit(corrupted, ",", "[", "].", 1024, message);
        return message.toString();
    }
}

