/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public final class SourceFilter {
    private Function<Map<String, Object>, Map<String, Object>> mapFilter = null;
    private Function<Source, Source> bytesFilter = null;
    private final boolean canFilterBytes;
    private final boolean empty;
    private final String[] includes;
    private final String[] excludes;

    public SourceFilter(String[] includes, String[] excludes) {
        this.includes = includes == null ? Strings.EMPTY_ARRAY : includes;
        this.excludes = excludes == null ? Strings.EMPTY_ARRAY : excludes;
        this.canFilterBytes = CollectionUtils.isEmpty(excludes) || Arrays.stream(excludes).noneMatch(field -> field.contains("*"));
        this.empty = CollectionUtils.isEmpty(this.includes) && CollectionUtils.isEmpty(this.excludes);
    }

    public Source filterMap(Source in) {
        if (this.empty) {
            return in;
        }
        if (this.mapFilter == null) {
            this.mapFilter = XContentMapValues.filter(this.includes, this.excludes);
        }
        return Source.fromMap(this.mapFilter.apply(in.source()), in.sourceContentType());
    }

    public Source filterBytes(Source in) {
        if (this.empty) {
            return in;
        }
        if (this.bytesFilter == null) {
            this.bytesFilter = this.buildBytesFilter();
        }
        return this.bytesFilter.apply(in);
    }

    private Function<Source, Source> buildBytesFilter() {
        if (!this.canFilterBytes) {
            return this::filterMap;
        }
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withFiltering(Set.copyOf(Arrays.asList(this.includes)), Set.copyOf(Arrays.asList(this.excludes)), true);
        return in -> {
            try {
                BytesStreamOutput streamOutput = new BytesStreamOutput(1024);
                XContent xContent = in.sourceContentType().xContent();
                XContentBuilder builder = new XContentBuilder(xContent, (OutputStream)streamOutput);
                XContentParser parser = xContent.createParser(parserConfig, (InputStream)in.internalSourceRef().streamInput());
                if (parser.currentToken() == null && parser.nextToken() == null) {
                    return Source.empty(in.sourceContentType());
                }
                builder.copyCurrentStructure(parser);
                return Source.fromBytes(BytesReference.bytes(builder));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }
}

