/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class Min
extends InternalNumericMetricsAggregation.SingleValue {
    private final double min;
    private final boolean nonEmpty;

    public Min(String name, double min, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, formatter, metadata);
        this.min = min;
        this.nonEmpty = true;
    }

    public static Min createEmptyMin(String name, DocValueFormat formatter, Map<String, Object> metadata) {
        return new Min(name, formatter, metadata);
    }

    private Min(String name, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, formatter, metadata);
        this.min = Double.POSITIVE_INFINITY;
        this.nonEmpty = false;
    }

    public Min(StreamInput in) throws IOException {
        super(in);
        this.min = in.readDouble();
        this.nonEmpty = this.min != Double.POSITIVE_INFINITY || this.format != DocValueFormat.RAW;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDouble(this.min);
    }

    @Override
    public String getWriteableName() {
        return "min";
    }

    @Override
    public double value() {
        return this.min;
    }

    @Override
    public Min reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        double min = Double.POSITIVE_INFINITY;
        for (InternalAggregation aggregation : aggregations) {
            min = Math.min(min, ((Min)aggregation).min);
        }
        return new Min(this.getName(), min, this.format, this.getMetadata());
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return this;
    }

    @Override
    public boolean canLeadReduction() {
        return this.nonEmpty;
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = !Double.isInfinite(this.min);
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), hasValue ? Double.valueOf(this.min) : null);
        if (hasValue && this.format != DocValueFormat.RAW) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(this.min).toString());
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.min);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Min other = (Min)obj;
        return Objects.equals(this.min, other.min);
    }
}

