/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;

public interface InferenceService
extends Closeable {
    default public void init(Client client) {
    }

    public String name();

    public Model parseRequestConfig(String var1, TaskType var2, Map<String, Object> var3, Set<String> var4);

    public Model parsePersistedConfigWithSecrets(String var1, TaskType var2, Map<String, Object> var3, Map<String, Object> var4);

    public Model parsePersistedConfig(String var1, TaskType var2, Map<String, Object> var3);

    public void infer(Model var1, List<String> var2, Map<String, Object> var3, ActionListener<InferenceServiceResults> var4);

    public void start(Model var1, ActionListener<Boolean> var2);

    default public void checkModelConfig(Model model, ActionListener<Model> listener) {
        listener.onResponse(model);
    }

    default public boolean isInClusterService() {
        return false;
    }

    public TransportVersion getMinimalSupportedVersion();
}

