/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.breaker;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public class CircuitBreakerMetrics {
    public static final CircuitBreakerMetrics NOOP = new CircuitBreakerMetrics(TelemetryProvider.NOOP, Collections.emptyMap());
    public static final String ES_BREAKER_PARENT_TRIP_COUNT_TOTAL = "es.breaker.parent.trip.total";
    public static final String ES_BREAKER_FIELD_DATA_TRIP_COUNT_TOTAL = "es.breaker.field_data.trip.total";
    public static final String ES_BREAKER_REQUEST_TRIP_COUNT_TOTAL = "es.breaker.request.trip.total";
    public static final String ES_BREAKER_IN_FLIGHT_REQUESTS_TRIP_COUNT_TOTAL = "es.breaker.in_flight_requests.trip.total";
    private static final String ES_BREAKER_CUSTOM_TRIP_COUNT_TOTAL_TEMPLATE = "es.breaker.%s.trip.total";
    private final MeterRegistry registry;
    private final LongCounter parentTripCountTotal;
    private final LongCounter fielddataTripCountTotal;
    private final LongCounter requestTripCountTotal;
    private final LongCounter inFlightRequestsCountTotal;
    private final Map<String, LongCounter> customTripCountsTotal;

    private CircuitBreakerMetrics(MeterRegistry registry, LongCounter parentTripCountTotal, LongCounter fielddataTripCountTotal, LongCounter requestTripCountTotal, LongCounter inFlightRequestsCountTotal, Map<String, LongCounter> customTripCountsTotal) {
        this.registry = registry;
        this.parentTripCountTotal = parentTripCountTotal;
        this.fielddataTripCountTotal = fielddataTripCountTotal;
        this.requestTripCountTotal = requestTripCountTotal;
        this.inFlightRequestsCountTotal = inFlightRequestsCountTotal;
        this.customTripCountsTotal = customTripCountsTotal;
    }

    public CircuitBreakerMetrics(TelemetryProvider telemetryProvider, Map<String, LongCounter> customTripCounters) {
        this(telemetryProvider.getMeterRegistry(), telemetryProvider.getMeterRegistry().registerLongCounter(ES_BREAKER_PARENT_TRIP_COUNT_TOTAL, "Parent circuit breaker trip count", "count"), telemetryProvider.getMeterRegistry().registerLongCounter(ES_BREAKER_FIELD_DATA_TRIP_COUNT_TOTAL, "Field data circuit breaker trip count", "count"), telemetryProvider.getMeterRegistry().registerLongCounter(ES_BREAKER_REQUEST_TRIP_COUNT_TOTAL, "Request circuit breaker trip count", "count"), telemetryProvider.getMeterRegistry().registerLongCounter(ES_BREAKER_IN_FLIGHT_REQUESTS_TRIP_COUNT_TOTAL, "In-flight requests circuit breaker trip count", "count"), customTripCounters);
    }

    public LongCounter getParentTripCountTotal() {
        return this.parentTripCountTotal;
    }

    public LongCounter getFielddataTripCountTotal() {
        return this.fielddataTripCountTotal;
    }

    public LongCounter getRequestTripCountTotal() {
        return this.requestTripCountTotal;
    }

    public LongCounter getInFlightRequestsCountTotal() {
        return this.inFlightRequestsCountTotal;
    }

    public Map<String, LongCounter> getCustomTripCountsTotal() {
        return this.customTripCountsTotal;
    }

    public LongCounter getCustomTripCount(String name, LongCounter theDefault) {
        return this.customTripCountsTotal.getOrDefault(name, theDefault);
    }

    public LongCounter getCustomTripCount(String name) {
        return this.customTripCountsTotal.getOrDefault(name, LongCounter.NOOP);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CircuitBreakerMetrics that = (CircuitBreakerMetrics)o;
        return Objects.equals(this.registry, that.registry) && Objects.equals(this.parentTripCountTotal, that.parentTripCountTotal) && Objects.equals(this.fielddataTripCountTotal, that.fielddataTripCountTotal) && Objects.equals(this.requestTripCountTotal, that.requestTripCountTotal) && Objects.equals(this.inFlightRequestsCountTotal, that.inFlightRequestsCountTotal) && Objects.equals(this.customTripCountsTotal, that.customTripCountsTotal);
    }

    public int hashCode() {
        return Objects.hash(this.registry, this.parentTripCountTotal, this.fielddataTripCountTotal, this.requestTripCountTotal, this.inFlightRequestsCountTotal, this.customTripCountsTotal);
    }

    public String toString() {
        return "CircuitBreakerMetrics{registry=" + this.registry + ", parentTripCountTotal=" + this.parentTripCountTotal + ", fielddataTripCountTotal=" + this.fielddataTripCountTotal + ", requestTripCountTotal=" + this.requestTripCountTotal + ", inFlightRequestsCountTotal=" + this.inFlightRequestsCountTotal + ", customTripCountsTotal=" + this.customTripCountsTotal + "}";
    }

    public void addCustomCircuitBreaker(CircuitBreaker circuitBreaker) {
        if (this.customTripCountsTotal.containsKey(circuitBreaker.getName())) {
            throw new IllegalArgumentException("A circuit circuitBreaker named [" + circuitBreaker.getName() + " already exists");
        }
        String canonicalName = Strings.format(ES_BREAKER_CUSTOM_TRIP_COUNT_TOTAL_TEMPLATE, circuitBreaker.getName());
        this.customTripCountsTotal.put(canonicalName, this.registry.registerLongCounter(canonicalName, "A custom circuit circuitBreaker [" + circuitBreaker.getName() + "]", "count"));
    }
}

