/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.indices.IndexPatternMatcher;

public class AssociatedIndexDescriptor
implements IndexPatternMatcher {
    private final String indexPattern;
    private final String description;
    private final CharacterRunAutomaton indexPatternAutomaton;

    public AssociatedIndexDescriptor(String indexPattern, String description) {
        Objects.requireNonNull(indexPattern, "associated index pattern must not be null");
        if (indexPattern.length() < 2) {
            throw new IllegalArgumentException("associated index pattern provided as [" + indexPattern + "] but must at least 2 characters in length");
        }
        if (indexPattern.charAt(0) != '.') {
            throw new IllegalArgumentException("associated index pattern provided as [" + indexPattern + "] but must start with the character [.]");
        }
        if (indexPattern.charAt(1) == '*') {
            throw new IllegalArgumentException("associated index pattern provided as [" + indexPattern + "] but must not start with the character sequence [.*] to prevent conflicts");
        }
        this.indexPattern = indexPattern;
        Automaton automaton = AssociatedIndexDescriptor.buildAutomaton(indexPattern);
        this.indexPatternAutomaton = new CharacterRunAutomaton(automaton);
        this.description = description;
    }

    @Override
    public String getIndexPattern() {
        return this.indexPattern;
    }

    public String getDescription() {
        return this.description;
    }

    static Automaton buildAutomaton(String pattern) {
        String output = pattern;
        output = output.replaceAll("\\.", "\\\\.");
        output = output.replaceAll("\\*", ".*");
        return new RegExp(output).toAutomaton();
    }

    @Override
    public List<String> getMatchingIndices(Metadata metadata) {
        return metadata.indices().keySet().stream().filter(this::matchesIndexPattern).toList();
    }

    private boolean matchesIndexPattern(String index) {
        return this.indexPatternAutomaton.run(index);
    }

    public String toString() {
        return "AssociatedIndexDescriptor{indexPattern='" + this.indexPattern + "', description='" + this.description + "', indexPatternAutomaton=" + this.indexPatternAutomaton + "}";
    }
}

