/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.snapshots;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.snapshots.AbortedSnapshotException;

public class IndexShardSnapshotStatus {
    private final AtomicReference<Stage> stage;
    private final AtomicReference<ShardGeneration> generation;
    private final AtomicReference<ShardSnapshotResult> shardSnapshotResult;
    private long startTime;
    private long totalTime;
    private int incrementalFileCount;
    private int totalFileCount;
    private int processedFileCount;
    private long totalSize;
    private long incrementalSize;
    private long processedSize;
    private String failure;
    private final SubscribableListener<AbortStatus> abortListeners = new SubscribableListener();

    private IndexShardSnapshotStatus(Stage stage, long startTime, long totalTime, int incrementalFileCount, int totalFileCount, int processedFileCount, long incrementalSize, long totalSize, long processedSize, String failure, ShardGeneration generation) {
        this.stage = new AtomicReference<Stage>(Objects.requireNonNull(stage));
        this.generation = new AtomicReference<ShardGeneration>(generation);
        this.shardSnapshotResult = new AtomicReference();
        this.startTime = startTime;
        this.totalTime = totalTime;
        this.incrementalFileCount = incrementalFileCount;
        this.totalFileCount = totalFileCount;
        this.processedFileCount = processedFileCount;
        this.totalSize = totalSize;
        this.processedSize = processedSize;
        this.incrementalSize = incrementalSize;
        this.failure = failure;
    }

    public synchronized Copy moveToStarted(long startTime, int incrementalFileCount, int totalFileCount, long incrementalSize, long totalSize) {
        if (!this.stage.compareAndSet(Stage.INIT, Stage.STARTED)) {
            this.ensureNotAborted();
            assert (false) : "Should not try to move stage [" + (Object)((Object)this.stage.get()) + "] to [STARTED]";
            throw new IllegalStateException("Unable to move the shard snapshot status to [STARTED]: expecting [INIT] but got [" + (Object)((Object)this.stage.get()) + "]");
        }
        this.startTime = startTime;
        this.incrementalFileCount = incrementalFileCount;
        this.totalFileCount = totalFileCount;
        this.incrementalSize = incrementalSize;
        this.totalSize = totalSize;
        return this.asCopy();
    }

    public synchronized Copy moveToFinalize() {
        Stage prevStage = this.stage.compareAndExchange(Stage.STARTED, Stage.FINALIZE);
        switch (prevStage) {
            case STARTED: {
                this.abortListeners.onResponse(AbortStatus.NO_ABORT);
                break;
            }
            case ABORTED: {
                throw new AbortedSnapshotException();
            }
            default: {
                String message = Strings.format("Unable to move the shard snapshot status to [FINALIZE]: expecting [STARTED] but got [%s]", new Object[]{prevStage});
                assert (false) : message;
                throw new IllegalStateException(message);
            }
        }
        return this.asCopy();
    }

    public synchronized void moveToDone(long endTime, ShardSnapshotResult shardSnapshotResult) {
        assert (shardSnapshotResult != null);
        assert (shardSnapshotResult.getGeneration() != null);
        if (!this.stage.compareAndSet(Stage.FINALIZE, Stage.DONE)) {
            assert (false) : "Should not try to move stage [" + (Object)((Object)this.stage.get()) + "] to [DONE]";
            throw new IllegalStateException("Unable to move the shard snapshot status to [DONE]: expecting [FINALIZE] but got [" + (Object)((Object)this.stage.get()) + "]");
        }
        this.totalTime = Math.max(0L, endTime - this.startTime);
        this.shardSnapshotResult.set(shardSnapshotResult);
        this.generation.set(shardSnapshotResult.getGeneration());
    }

    public void addAbortListener(ActionListener<AbortStatus> listener) {
        this.abortListeners.addListener(listener);
    }

    public synchronized void abortIfNotCompleted(String failure, Consumer<ActionListener<Releasable>> notifyRunner) {
        if (this.stage.compareAndSet(Stage.INIT, Stage.ABORTED) || this.stage.compareAndSet(Stage.STARTED, Stage.ABORTED)) {
            this.failure = failure;
            notifyRunner.accept(this.abortListeners.map(r -> {
                Releasables.closeExpectNoException((Releasable)r);
                return AbortStatus.ABORTED;
            }));
        }
    }

    public synchronized void moveToFailed(long endTime, String failure) {
        if (this.stage.getAndSet(Stage.FAILURE) != Stage.FAILURE) {
            this.abortListeners.onResponse(AbortStatus.NO_ABORT);
            this.totalTime = Math.max(0L, endTime - this.startTime);
            this.failure = failure;
        }
    }

    public ShardGeneration generation() {
        return this.generation.get();
    }

    public ShardSnapshotResult getShardSnapshotResult() {
        assert (this.stage.get() == Stage.DONE) : this.stage.get();
        return this.shardSnapshotResult.get();
    }

    public void ensureNotAborted() {
        if (this.stage.get() == Stage.ABORTED) {
            throw new AbortedSnapshotException();
        }
    }

    public synchronized void addProcessedFile(long size) {
        ++this.processedFileCount;
        this.processedSize += size;
    }

    public synchronized void addProcessedFiles(int count, long totalSize) {
        this.processedFileCount += count;
        this.processedSize += totalSize;
    }

    public synchronized Copy asCopy() {
        return new Copy(this.stage.get(), this.startTime, this.totalTime, this.incrementalFileCount, this.totalFileCount, this.processedFileCount, this.incrementalSize, this.totalSize, this.processedSize, this.failure);
    }

    public static IndexShardSnapshotStatus newInitializing(ShardGeneration generation) {
        return new IndexShardSnapshotStatus(Stage.INIT, 0L, 0L, 0, 0, 0, 0L, 0L, 0L, null, generation);
    }

    public static Copy newFailed(String failure) {
        assert (failure != null) : "expecting non null failure for a failed IndexShardSnapshotStatus";
        if (failure == null) {
            throw new IllegalArgumentException("A failure description is required for a failed IndexShardSnapshotStatus");
        }
        return new IndexShardSnapshotStatus(Stage.FAILURE, 0L, 0L, 0, 0, 0, 0L, 0L, 0L, failure, null).asCopy();
    }

    public static Copy newDone(long startTime, long totalTime, int incrementalFileCount, int fileCount, long incrementalSize, long size, ShardGeneration generation) {
        return new IndexShardSnapshotStatus(Stage.DONE, startTime, totalTime, incrementalFileCount, fileCount, incrementalFileCount, incrementalSize, size, incrementalSize, null, generation).asCopy();
    }

    public static enum Stage {
        INIT,
        STARTED,
        FINALIZE,
        DONE,
        FAILURE,
        ABORTED;

    }

    public static class Copy {
        private final Stage stage;
        private final long startTime;
        private final long totalTime;
        private final int incrementalFileCount;
        private final int totalFileCount;
        private final int processedFileCount;
        private final long totalSize;
        private final long processedSize;
        private final long incrementalSize;
        private final String failure;

        public Copy(Stage stage, long startTime, long totalTime, int incrementalFileCount, int totalFileCount, int processedFileCount, long incrementalSize, long totalSize, long processedSize, String failure) {
            this.stage = stage;
            this.startTime = startTime;
            this.totalTime = totalTime;
            this.incrementalFileCount = incrementalFileCount;
            this.totalFileCount = totalFileCount;
            this.processedFileCount = processedFileCount;
            this.totalSize = totalSize;
            this.processedSize = processedSize;
            this.incrementalSize = incrementalSize;
            this.failure = failure;
        }

        public Stage getStage() {
            return this.stage;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getTotalTime() {
            return this.totalTime;
        }

        public int getIncrementalFileCount() {
            return this.incrementalFileCount;
        }

        public int getTotalFileCount() {
            return this.totalFileCount;
        }

        public int getProcessedFileCount() {
            return this.processedFileCount;
        }

        public long getIncrementalSize() {
            return this.incrementalSize;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public long getProcessedSize() {
            return this.processedSize;
        }

        public String getFailure() {
            return this.failure;
        }

        public String toString() {
            return "index shard snapshot status (stage=" + this.stage + ", startTime=" + this.startTime + ", totalTime=" + this.totalTime + ", incrementalFileCount=" + this.incrementalFileCount + ", totalFileCount=" + this.totalFileCount + ", processedFileCount=" + this.processedFileCount + ", incrementalSize=" + this.incrementalSize + ", totalSize=" + this.totalSize + ", processedSize=" + this.processedSize + ", failure='" + this.failure + "')";
        }
    }

    public static enum AbortStatus {
        NO_ABORT,
        ABORTED;

    }
}

