/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.seqno;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class RetentionLeaseActions {
    public static final long RETAIN_ALL = -1L;

    public static class RemoveRequest
    extends Request<RemoveRequest> {
        RemoveRequest(StreamInput in) throws IOException {
            super(in);
        }

        public RemoveRequest(ShardId shardId, String id) {
            super(shardId, id);
        }
    }

    public static class RenewRequest
    extends AddOrRenewRequest<RenewRequest> {
        RenewRequest(StreamInput in) throws IOException {
            super(in);
        }

        public RenewRequest(ShardId shardId, String id, long retainingSequenceNumber, String source) {
            super(shardId, id, retainingSequenceNumber, source);
        }
    }

    public static class AddRequest
    extends AddOrRenewRequest<AddRequest> {
        AddRequest(StreamInput in) throws IOException {
            super(in);
        }

        public AddRequest(ShardId shardId, String id, long retainingSequenceNumber, String source) {
            super(shardId, id, retainingSequenceNumber, source);
        }
    }

    private static abstract class AddOrRenewRequest<T extends SingleShardRequest<T>>
    extends Request<T> {
        private final long retainingSequenceNumber;
        private final String source;

        public long getRetainingSequenceNumber() {
            return this.retainingSequenceNumber;
        }

        public String getSource() {
            return this.source;
        }

        AddOrRenewRequest(StreamInput in) throws IOException {
            super(in);
            this.retainingSequenceNumber = in.readZLong();
            this.source = in.readString();
        }

        AddOrRenewRequest(ShardId shardId, String id, long retainingSequenceNumber, String source) {
            super(shardId, id);
            if (retainingSequenceNumber < 0L && retainingSequenceNumber != -1L) {
                throw new IllegalArgumentException("retaining sequence number [" + retainingSequenceNumber + "] out of range");
            }
            this.retainingSequenceNumber = retainingSequenceNumber;
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeZLong(this.retainingSequenceNumber);
            out.writeString(this.source);
        }
    }

    private static abstract class Request<T extends SingleShardRequest<T>>
    extends SingleShardRequest<T> {
        private final ShardId shardId;
        private final String id;

        public ShardId getShardId() {
            return this.shardId;
        }

        public String getId() {
            return this.id;
        }

        Request(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.id = in.readString();
        }

        Request(ShardId shardId, String id) {
            super(Objects.requireNonNull(shardId).getIndexName());
            this.shardId = shardId;
            this.id = Objects.requireNonNull(id);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeString(this.id);
        }
    }

    public static class Remove
    extends ActionType<ActionResponse.Empty> {
        public static final Remove INSTANCE = new Remove();
        public static final String ACTION_NAME = "indices:admin/seq_no/remove_retention_lease";

        private Remove() {
            super(ACTION_NAME, in -> ActionResponse.Empty.INSTANCE);
        }

        public static class TransportAction
        extends TransportRetentionLeaseAction<RemoveRequest> {
            @Inject
            public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
                super(Remove.ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, indicesService, RemoveRequest::new);
            }

            @Override
            void doRetentionLeaseAction(IndexShard indexShard, RemoveRequest request, ActionListener<ActionResponse.Empty> listener) {
                indexShard.removeRetentionLease(request.getId(), listener.map(r -> ActionResponse.Empty.INSTANCE));
            }
        }
    }

    public static class Renew
    extends ActionType<ActionResponse.Empty> {
        public static final Renew INSTANCE = new Renew();
        public static final String ACTION_NAME = "indices:admin/seq_no/renew_retention_lease";

        private Renew() {
            super(ACTION_NAME, in -> ActionResponse.Empty.INSTANCE);
        }

        public static class TransportAction
        extends TransportRetentionLeaseAction<RenewRequest> {
            @Inject
            public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
                super(Renew.ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, indicesService, RenewRequest::new);
            }

            @Override
            void doRetentionLeaseAction(IndexShard indexShard, RenewRequest request, ActionListener<ActionResponse.Empty> listener) {
                indexShard.renewRetentionLease(request.getId(), request.getRetainingSequenceNumber(), request.getSource());
                listener.onResponse(ActionResponse.Empty.INSTANCE);
            }
        }
    }

    public static class Add
    extends ActionType<ActionResponse.Empty> {
        public static final Add INSTANCE = new Add();
        public static final String ACTION_NAME = "indices:admin/seq_no/add_retention_lease";

        private Add() {
            super(ACTION_NAME, in -> ActionResponse.Empty.INSTANCE);
        }

        public static class TransportAction
        extends TransportRetentionLeaseAction<AddRequest> {
            @Inject
            public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
                super(Add.ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, indicesService, AddRequest::new);
            }

            @Override
            void doRetentionLeaseAction(IndexShard indexShard, AddRequest request, ActionListener<ActionResponse.Empty> listener) {
                indexShard.addRetentionLease(request.getId(), request.getRetainingSequenceNumber(), request.getSource(), listener.map(r -> ActionResponse.Empty.INSTANCE));
            }
        }
    }

    static abstract class TransportRetentionLeaseAction<T extends Request<T>>
    extends TransportSingleShardAction<T, ActionResponse.Empty> {
        private final IndicesService indicesService;

        @Inject
        TransportRetentionLeaseAction(String name, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService, Writeable.Reader<T> requestSupplier) {
            super(name, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, requestSupplier, threadPool.executor("management"));
            this.indicesService = Objects.requireNonNull(indicesService);
        }

        @Override
        protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
            return state.routingTable().shardRoutingTable(request.concreteIndex(), ((Request)request.request()).getShardId().id()).primaryShardIt();
        }

        @Override
        protected void asyncShardOperation(T request, ShardId shardId, ActionListener<ActionResponse.Empty> listener) {
            IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
            IndexShard indexShard = indexService.getShard(shardId.id());
            indexShard.acquirePrimaryOperationPermit(listener.delegateFailureAndWrap((delegatedListener, releasable) -> {
                try (Releasable ignore = releasable;){
                    this.doRetentionLeaseAction(indexShard, request, (ActionListener<ActionResponse.Empty>)delegatedListener);
                }
            }), EsExecutors.DIRECT_EXECUTOR_SERVICE);
        }

        @Override
        protected ActionResponse.Empty shardOperation(T request, ShardId shardId) {
            throw new UnsupportedOperationException();
        }

        abstract void doRetentionLeaseAction(IndexShard var1, T var2, ActionListener<ActionResponse.Empty> var3);

        @Override
        protected final Writeable.Reader<ActionResponse.Empty> getResponseReader() {
            return in -> ActionResponse.Empty.INSTANCE;
        }

        @Override
        protected boolean resolveIndex(T request) {
            return false;
        }
    }
}

