/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.index.fielddata.BooleanScriptDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.LeafLongFieldData;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.BooleanFieldScript;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public final class BooleanScriptFieldData
extends IndexNumericFieldData {
    private final String fieldName;
    private final BooleanFieldScript.LeafFactory leafFactory;
    protected final ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory;

    private BooleanScriptFieldData(String fieldName, BooleanFieldScript.LeafFactory leafFactory, ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory) {
        this.fieldName = fieldName;
        this.leafFactory = leafFactory;
        this.toScriptFieldFactory = toScriptFieldFactory;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return CoreValuesSourceType.BOOLEAN;
    }

    @Override
    public BooleanScriptLeafFieldData load(LeafReaderContext context) {
        try {
            return this.loadDirect(context);
        }
        catch (Exception e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }

    @Override
    public BooleanScriptLeafFieldData loadDirect(LeafReaderContext context) {
        return new BooleanScriptLeafFieldData(new BooleanScriptDocValues(this.leafFactory.newInstance(context)), this.toScriptFieldFactory);
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return IndexNumericFieldData.NumericType.BOOLEAN;
    }

    @Override
    protected boolean sortRequiresCustomComparator() {
        return true;
    }

    public static class BooleanScriptLeafFieldData
    extends LeafLongFieldData {
        private final BooleanScriptDocValues booleanScriptDocValues;
        protected final ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory;

        BooleanScriptLeafFieldData(BooleanScriptDocValues booleanScriptDocValues, ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory) {
            super(0L);
            this.booleanScriptDocValues = booleanScriptDocValues;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        @Override
        public SortedNumericDocValues getLongValues() {
            return this.booleanScriptDocValues;
        }

        @Override
        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
            return this.toScriptFieldFactory.getScriptFieldFactory(this.getLongValues(), name);
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final BooleanFieldScript.LeafFactory leafFactory;
        protected final ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory;

        public Builder(String name, BooleanFieldScript.LeafFactory leafFactory, ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory) {
            this.name = name;
            this.leafFactory = leafFactory;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        public BooleanScriptFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new BooleanScriptFieldData(this.name, this.leafFactory, this.toScriptFieldFactory);
        }
    }
}

