/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.elasticsearch.common.lucene.FilterIndexCommit;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.engine.SafeCommitInfo;
import org.elasticsearch.index.engine.SoftDeletesPolicy;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.translog.TranslogDeletionPolicy;

public class CombinedDeletionPolicy
extends IndexDeletionPolicy {
    private final Logger logger;
    private final TranslogDeletionPolicy translogDeletionPolicy;
    private final SoftDeletesPolicy softDeletesPolicy;
    private final LongSupplier globalCheckpointSupplier;
    private final Map<IndexCommit, Integer> snapshottedCommits;
    @Nullable
    private final CommitsListener commitsListener;
    private volatile IndexCommit safeCommit;
    private volatile long maxSeqNoOfNextSafeCommit;
    private volatile IndexCommit lastCommit;
    private volatile SafeCommitInfo safeCommitInfo = SafeCommitInfo.EMPTY;

    CombinedDeletionPolicy(Logger logger, TranslogDeletionPolicy translogDeletionPolicy, SoftDeletesPolicy softDeletesPolicy, LongSupplier globalCheckpointSupplier, @Nullable CommitsListener commitsListener) {
        this.logger = logger;
        this.translogDeletionPolicy = translogDeletionPolicy;
        this.softDeletesPolicy = softDeletesPolicy;
        this.globalCheckpointSupplier = globalCheckpointSupplier;
        this.commitsListener = commitsListener;
        this.snapshottedCommits = new HashMap<IndexCommit, Integer>();
    }

    public void onInit(List<? extends IndexCommit> commits) throws IOException {
        assert (!commits.isEmpty()) : "index is opened, but we have no commits";
        this.onCommit(commits);
        if (this.safeCommit != commits.get(commits.size() - 1)) {
            throw new IllegalStateException("Engine is opened, but the last commit isn't safe. Global checkpoint [" + this.globalCheckpointSupplier.getAsLong() + "], seqNo is last commit [" + SequenceNumbers.loadSeqNoInfoFromLuceneCommit(this.lastCommit.getUserData().entrySet()) + "], seqNos in safe commit [" + SequenceNumbers.loadSeqNoInfoFromLuceneCommit(this.safeCommit.getUserData().entrySet()) + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommit(List<? extends IndexCommit> commits) throws IOException {
        int totalDocsOfSafeCommit;
        assert (!Thread.holdsLock((Object)this)) : "should not block concurrent acquire or release";
        int keptPosition = CombinedDeletionPolicy.indexOfKeptCommits(commits, this.globalCheckpointSupplier.getAsLong());
        IndexCommit safeCommit = commits.get(keptPosition);
        try {
            totalDocsOfSafeCommit = this.getDocCountOfCommit(safeCommit);
        }
        catch (IOException ex) {
            this.logger.info("failed to get the total docs from the safe commit; use the total docs from the previous safe commit", (Throwable)ex);
            totalDocsOfSafeCommit = this.safeCommitInfo.docCount;
        }
        IndexCommit newCommit = null;
        IndexCommit previousLastCommit = null;
        ArrayList<IndexCommit> deletedCommits = null;
        CombinedDeletionPolicy combinedDeletionPolicy = this;
        synchronized (combinedDeletionPolicy) {
            this.safeCommitInfo = new SafeCommitInfo(Long.parseLong((String)safeCommit.getUserData().get("local_checkpoint")), totalDocsOfSafeCommit);
            previousLastCommit = this.lastCommit;
            this.lastCommit = commits.get(commits.size() - 1);
            this.safeCommit = safeCommit;
            this.updateRetentionPolicy();
            this.maxSeqNoOfNextSafeCommit = keptPosition == commits.size() - 1 ? Long.MAX_VALUE : Long.parseLong((String)commits.get(keptPosition + 1).getUserData().get("max_seq_no"));
            if (this.commitsListener != null && previousLastCommit != this.lastCommit) {
                newCommit = this.acquireIndexCommit(false);
            }
            for (int i = 0; i < keptPosition; ++i) {
                IndexCommit commit = commits.get(i);
                if (this.snapshottedCommits.containsKey(commit)) continue;
                this.deleteCommit(commit);
                if (deletedCommits == null) {
                    deletedCommits = new ArrayList<IndexCommit>();
                }
                deletedCommits.add(commit);
            }
        }
        assert (this.assertSafeCommitUnchanged(safeCommit));
        if (this.commitsListener != null) {
            if (newCommit != null) {
                Set<String> additionalFiles = CombinedDeletionPolicy.listOfNewFileNames(previousLastCommit, newCommit);
                this.commitsListener.onNewAcquiredCommit(newCommit, additionalFiles);
            }
            if (deletedCommits != null) {
                for (IndexCommit deletedCommit : deletedCommits) {
                    this.commitsListener.onDeletedCommit(deletedCommit);
                }
            }
        }
    }

    private boolean assertSafeCommitUnchanged(IndexCommit safeCommit) {
        IndexCommit newSafeCommit = this.safeCommit;
        assert (safeCommit == newSafeCommit) : "onCommit called concurrently? " + safeCommit.getGeneration() + " vs " + newSafeCommit.getGeneration();
        return true;
    }

    private void deleteCommit(IndexCommit commit) throws IOException {
        assert (!commit.isDeleted()) : "Index commit [" + CombinedDeletionPolicy.commitDescription(commit) + "] is deleted twice";
        this.logger.debug("Delete index commit [{}]", (Object)CombinedDeletionPolicy.commitDescription(commit));
        commit.delete();
        assert (commit.isDeleted()) : "Deletion commit [" + CombinedDeletionPolicy.commitDescription(commit) + "] was suppressed";
    }

    private void updateRetentionPolicy() throws IOException {
        assert (Thread.holdsLock((Object)this));
        this.logger.debug("Safe commit [{}], last commit [{}]", (Object)CombinedDeletionPolicy.commitDescription(this.safeCommit), (Object)CombinedDeletionPolicy.commitDescription(this.lastCommit));
        assert (!this.safeCommit.isDeleted()) : "The safe commit must not be deleted";
        assert (!this.lastCommit.isDeleted()) : "The last commit must not be deleted";
        long localCheckpointOfSafeCommit = Long.parseLong((String)this.safeCommit.getUserData().get("local_checkpoint"));
        this.softDeletesPolicy.setLocalCheckpointOfSafeCommit(localCheckpointOfSafeCommit);
        this.translogDeletionPolicy.setLocalCheckpointOfSafeCommit(localCheckpointOfSafeCommit);
    }

    protected int getDocCountOfCommit(IndexCommit indexCommit) throws IOException {
        return SegmentInfos.readCommit((Directory)indexCommit.getDirectory(), (String)indexCommit.getSegmentsFileName()).totalMaxDoc();
    }

    SafeCommitInfo getSafeCommitInfo() {
        return this.safeCommitInfo;
    }

    synchronized IndexCommit acquireIndexCommit(boolean acquiringSafeCommit) {
        assert (this.safeCommit != null) : "Safe commit is not initialized yet";
        assert (this.lastCommit != null) : "Last commit is not initialized yet";
        IndexCommit snapshotting = acquiringSafeCommit ? this.safeCommit : this.lastCommit;
        this.snapshottedCommits.merge(snapshotting, 1, Integer::sum);
        return this.wrapCommit(snapshotting);
    }

    protected IndexCommit wrapCommit(IndexCommit indexCommit) {
        return new SnapshotIndexCommit(indexCommit);
    }

    synchronized boolean releaseCommit(IndexCommit snapshotCommit) {
        IndexCommit releasingCommit = ((SnapshotIndexCommit)snapshotCommit).getIndexCommit();
        assert (this.snapshottedCommits.containsKey(releasingCommit)) : "Release non-snapshotted commit;snapshotted commits [" + this.snapshottedCommits + "], releasing commit [" + releasingCommit + "]";
        Integer refCount = this.snapshottedCommits.compute(releasingCommit, (key, count) -> {
            if (count == 1) {
                return null;
            }
            return count - 1;
        });
        assert (refCount == null || refCount > 0) : "Number of snapshots can not be negative [" + refCount + "]";
        return refCount == null && !releasingCommit.equals((Object)this.safeCommit) && !releasingCommit.equals((Object)this.lastCommit);
    }

    public static IndexCommit findSafeCommitPoint(List<IndexCommit> commits, long globalCheckpoint) throws IOException {
        if (commits.isEmpty()) {
            throw new IllegalArgumentException("Commit list must not empty");
        }
        int keptPosition = CombinedDeletionPolicy.indexOfKeptCommits(commits, globalCheckpoint);
        return commits.get(keptPosition);
    }

    private static int indexOfKeptCommits(List<? extends IndexCommit> commits, long globalCheckpoint) throws IOException {
        String expectedTranslogUUID = (String)commits.get(commits.size() - 1).getUserData().get("translog_uuid");
        for (int i = commits.size() - 1; i >= 0; --i) {
            Map commitUserData = commits.get(i).getUserData();
            if (!expectedTranslogUUID.equals(commitUserData.get("translog_uuid"))) {
                return i + 1;
            }
            long maxSeqNoFromCommit = Long.parseLong((String)commitUserData.get("max_seq_no"));
            if (maxSeqNoFromCommit > globalCheckpoint) continue;
            return i;
        }
        return 0;
    }

    private static Set<String> listOfNewFileNames(IndexCommit previous, IndexCommit current) throws IOException {
        HashSet previousFiles = previous != null ? new HashSet(previous.getFileNames()) : Set.of();
        return current.getFileNames().stream().filter(f -> !previousFiles.contains(f)).collect(Collectors.toUnmodifiableSet());
    }

    synchronized boolean hasSnapshottedCommits() {
        return !this.snapshottedCommits.isEmpty();
    }

    boolean hasUnreferencedCommits() {
        return this.maxSeqNoOfNextSafeCommit <= this.globalCheckpointSupplier.getAsLong();
    }

    public static String commitDescription(IndexCommit commit) throws IOException {
        return String.format(Locale.ROOT, "CommitPoint{segment[%s], userData[%s]}", commit.getSegmentsFileName(), commit.getUserData());
    }

    static interface CommitsListener {
        public void onNewAcquiredCommit(IndexCommit var1, Set<String> var2);

        public void onDeletedCommit(IndexCommit var1);
    }

    private static class SnapshotIndexCommit
    extends FilterIndexCommit {
        SnapshotIndexCommit(IndexCommit delegate) {
            super(delegate);
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("A snapshot commit does not support deletion");
        }
    }
}

