/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination.stateless;

import java.util.OptionalLong;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.cluster.coordination.LeaderHeartbeatService;
import org.elasticsearch.cluster.coordination.stateless.Heartbeat;
import org.elasticsearch.cluster.coordination.stateless.HeartbeatStore;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;

public class StoreHeartbeatService
implements LeaderHeartbeatService {
    public static final Setting<TimeValue> HEARTBEAT_FREQUENCY = Setting.timeSetting("cluster.stateless.heartbeat_frequency", TimeValue.timeValueSeconds((long)15L), TimeValue.timeValueSeconds((long)1L), Setting.Property.NodeScope);
    public static final Setting<Integer> MAX_MISSED_HEARTBEATS = Setting.intSetting("cluster.stateless.max_missed_heartbeats", 2, 1, Setting.Property.NodeScope);
    private static final Logger logger = LogManager.getLogger(StoreHeartbeatService.class);
    private final HeartbeatStore heartbeatStore;
    private final ThreadPool threadPool;
    private final TimeValue heartbeatFrequency;
    private final TimeValue retryAfterTermReadFailureDelay;
    private final TimeValue maxTimeSinceLastHeartbeat;
    private final Consumer<ActionListener<OptionalLong>> currentTermSupplier;
    private volatile HeartbeatTask heartbeatTask;

    public static StoreHeartbeatService create(HeartbeatStore heartbeatStore, ThreadPool threadPool, Settings settings, Consumer<ActionListener<OptionalLong>> currentTermSupplier) {
        TimeValue heartbeatFrequency = HEARTBEAT_FREQUENCY.get(settings);
        return new StoreHeartbeatService(heartbeatStore, threadPool, heartbeatFrequency, TimeValue.timeValueMillis((long)((long)MAX_MISSED_HEARTBEATS.get(settings).intValue() * heartbeatFrequency.millis())), currentTermSupplier);
    }

    public StoreHeartbeatService(HeartbeatStore heartbeatStore, ThreadPool threadPool, TimeValue heartbeatFrequency, TimeValue maxTimeSinceLastHeartbeat, Consumer<ActionListener<OptionalLong>> currentTermSupplier) {
        this.heartbeatStore = heartbeatStore;
        this.threadPool = threadPool;
        this.heartbeatFrequency = heartbeatFrequency;
        this.retryAfterTermReadFailureDelay = TimeValue.timeValueMillis((long)(heartbeatFrequency.millis() / 2L));
        this.maxTimeSinceLastHeartbeat = maxTimeSinceLastHeartbeat;
        this.currentTermSupplier = currentTermSupplier;
    }

    @Override
    public void start(DiscoveryNode currentLeader, long term, ActionListener<Long> completionListener) {
        HeartbeatTask newHeartbeatTask;
        this.heartbeatTask = newHeartbeatTask = new HeartbeatTask(term, completionListener);
        newHeartbeatTask.run();
    }

    @Override
    public void stop() {
        this.heartbeatTask = null;
    }

    protected long absoluteTimeInMillis() {
        return this.threadPool.absoluteTimeInMillis();
    }

    void runIfNoRecentLeader(final Runnable runnable) {
        this.heartbeatStore.readLatestHeartbeat(new ActionListener<Heartbeat>(){

            @Override
            public void onResponse(Heartbeat heartBeat) {
                if (heartBeat == null || StoreHeartbeatService.this.maxTimeSinceLastHeartbeat.millis() <= heartBeat.timeSinceLastHeartbeatInMillis(StoreHeartbeatService.this.absoluteTimeInMillis())) {
                    runnable.run();
                } else {
                    logger.trace("runIfNoRecentLeader: found recent leader [{}]", (Object)heartBeat);
                }
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn("failed to read heartbeat from store", (Throwable)e);
            }
        });
    }

    private class HeartbeatTask
    extends ActionRunnable<Long> {
        private final long heartbeatTerm;
        private final ActionListener<TimeValue> rerunListener;

        HeartbeatTask(long heartbeatTerm, ActionListener<Long> listener) {
            super(listener);
            assert (0L < heartbeatTerm) : heartbeatTerm;
            this.heartbeatTerm = heartbeatTerm;
            this.rerunListener = listener.delegateFailureAndWrap((l, scheduleDelay) -> StoreHeartbeatService.this.threadPool.schedule(this, (TimeValue)scheduleDelay, StoreHeartbeatService.this.threadPool.generic()));
        }

        @Override
        protected void doRun() throws Exception {
            if (StoreHeartbeatService.this.heartbeatTask != this) {
                return;
            }
            StoreHeartbeatService.this.currentTermSupplier.accept(this.rerunListener.delegateFailure((delegate, registerTermOpt) -> {
                if (registerTermOpt.isEmpty()) {
                    this.rerunListener.onResponse(StoreHeartbeatService.this.retryAfterTermReadFailureDelay);
                } else {
                    long registerTerm = registerTermOpt.getAsLong();
                    if (registerTerm == this.heartbeatTerm) {
                        StoreHeartbeatService.this.heartbeatStore.writeHeartbeat(new Heartbeat(this.heartbeatTerm, StoreHeartbeatService.this.absoluteTimeInMillis()), this.rerunListener.map(unused -> StoreHeartbeatService.this.heartbeatFrequency));
                    } else {
                        assert (this.heartbeatTerm < registerTerm) : this.heartbeatTerm + " vs " + registerTerm;
                        this.listener.onResponse(registerTerm);
                    }
                }
            }));
        }
    }
}

