/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.repositories.RepositoryOperation;
import org.elasticsearch.xcontent.ToXContent;

public final class RepositoryCleanupInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final RepositoryCleanupInProgress EMPTY = new RepositoryCleanupInProgress(List.of());
    public static final String TYPE = "repository_cleanup";
    private final List<Entry> entries;

    public static RepositoryCleanupInProgress get(ClusterState state) {
        return state.custom(TYPE, EMPTY);
    }

    public RepositoryCleanupInProgress(List<Entry> entries) {
        this.entries = entries;
    }

    RepositoryCleanupInProgress(StreamInput in) throws IOException {
        this.entries = in.readCollectionAsList(Entry::new);
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return RepositoryCleanupInProgress.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    public static Entry startedEntry(String repository, long repositoryStateId) {
        return new Entry(repository, repositoryStateId);
    }

    public boolean hasCleanupInProgress() {
        return !this.entries.isEmpty();
    }

    public List<Entry> entries() {
        return List.copyOf(this.entries);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.entries);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.concat(Iterators.single((builder, params) -> builder.startArray(TYPE)), Iterators.map(this.entries.iterator(), entry -> (builder, params) -> {
            builder.startObject();
            builder.field("repository", entry.repository);
            builder.endObject();
            return builder;
        }), Iterators.single((builder, params) -> builder.endArray()));
    }

    public String toString() {
        return Strings.toString(this);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_7_4_0;
    }

    public static final class Entry
    implements Writeable,
    RepositoryOperation {
        private final String repository;
        private final long repositoryStateId;

        private Entry(StreamInput in) throws IOException {
            this.repository = in.readString();
            this.repositoryStateId = in.readLong();
        }

        public Entry(String repository, long repositoryStateId) {
            this.repository = repository;
            this.repositoryStateId = repositoryStateId;
        }

        @Override
        public long repositoryStateId() {
            return this.repositoryStateId;
        }

        @Override
        public String repository() {
            return this.repository;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.repository);
            out.writeLong(this.repositoryStateId);
        }

        public String toString() {
            return "{" + this.repository + "}{" + this.repositoryStateId + "}";
        }
    }
}

