/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.refresh.TransportShardRefreshAction;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.get.MultiGetShardRequest;
import org.elasticsearch.action.get.MultiGetShardResponse;
import org.elasticsearch.action.get.TransportGetAction;
import org.elasticsearch.action.get.TransportShardMultiGetFomTranslogAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.replication.BasicReplicationRequest;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.ExecutorSelector;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportShardMultiGetAction
extends TransportSingleShardAction<MultiGetShardRequest, MultiGetShardResponse> {
    private static final String ACTION_NAME = "indices:data/read/mget[shard]";
    public static final ActionType<MultiGetShardResponse> TYPE = new ActionType<MultiGetShardResponse>("indices:data/read/mget[shard]", MultiGetShardResponse::new);
    private static final Logger logger = LogManager.getLogger(TransportShardMultiGetAction.class);
    private final IndicesService indicesService;
    private final ExecutorSelector executorSelector;
    private final NodeClient client;

    @Inject
    public TransportShardMultiGetAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ExecutorSelector executorSelector, NodeClient client) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, MultiGetShardRequest::new, threadPool.executor("get"));
        this.indicesService = indicesService;
        this.executorSelector = executorSelector;
        this.client = client;
    }

    @Override
    protected boolean isSubAction() {
        return true;
    }

    @Override
    protected Writeable.Reader<MultiGetShardResponse> getResponseReader() {
        return MultiGetShardResponse::new;
    }

    @Override
    protected boolean resolveIndex(MultiGetShardRequest request) {
        return true;
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        ShardIterator iterator = this.clusterService.operationRouting().getShards(state, ((MultiGetShardRequest)request.request()).index(), ((MultiGetShardRequest)request.request()).shardId(), ((MultiGetShardRequest)request.request()).preference());
        if (iterator == null) {
            return null;
        }
        return new PlainShardIterator(iterator.shardId(), iterator.getShardRoutings().stream().filter(shardRouting -> OperationRouting.canSearchShard(shardRouting, state)).toList());
    }

    @Override
    protected void asyncShardOperation(MultiGetShardRequest request, ShardId shardId, ActionListener<MultiGetShardResponse> listener) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (!indexShard.routingEntry().isPromotableToPrimary()) {
            assert (!indexShard.indexSettings().isFastRefresh()) : "a search shard should not receive a TransportShardMultiGetAction for an index with fast refresh";
            this.handleMultiGetOnUnpromotableShard(request, indexShard, listener);
            return;
        }
        assert (!DiscoveryNode.isStateless(this.clusterService.getSettings()) || indexShard.indexSettings().isFastRefresh()) : "in Stateless a promotable to primary shard can receive a TransportShardMultiGetAction only if an index has the fast refresh setting";
        if (request.realtime()) {
            this.asyncShardMultiGet(request, shardId, listener);
        } else {
            indexShard.ensureShardSearchActive(b -> {
                try {
                    this.asyncShardMultiGet(request, shardId, listener);
                }
                catch (Exception ex) {
                    listener.onFailure(ex);
                }
            });
        }
    }

    @Override
    protected MultiGetShardResponse shardOperation(MultiGetShardRequest request, ShardId shardId) {
        MultiGetShardResponse response = new MultiGetShardResponse();
        for (int i = 0; i < request.locations.size(); ++i) {
            this.getAndAddToResponse(shardId, i, request, response);
        }
        return response;
    }

    @Override
    protected Executor getExecutor(MultiGetShardRequest request, ShardId shardId) {
        ClusterState clusterState = this.clusterService.state();
        if (clusterState.metadata().index(shardId.getIndex()).isSystem()) {
            return this.threadPool.executor(this.executorSelector.executorForGet(shardId.getIndexName()));
        }
        if (this.indicesService.indexServiceSafe(shardId.getIndex()).getIndexSettings().isSearchThrottled()) {
            return this.threadPool.executor("search_throttled");
        }
        return super.getExecutor(request, shardId);
    }

    private void handleMultiGetOnUnpromotableShard(MultiGetShardRequest request, IndexShard indexShard, ActionListener<MultiGetShardResponse> listener) throws IOException {
        ShardId shardId = indexShard.shardId();
        DiscoveryNode node = TransportGetAction.getCurrentNodeOfPrimary(this.clusterService.state(), shardId);
        if (request.refresh()) {
            logger.trace("send refresh action for shard {} to node {}", new Object[]{shardId, node.getId()});
            BasicReplicationRequest refreshRequest = new BasicReplicationRequest(shardId);
            refreshRequest.setParentTask(request.getParentTask());
            this.client.executeLocally(TransportShardRefreshAction.TYPE, refreshRequest, listener.delegateFailureAndWrap((l, replicationResponse) -> super.asyncShardOperation(request, shardId, l)));
        } else if (request.realtime()) {
            TransportShardMultiGetFomTranslogAction.Request mgetFromTranslogRequest = new TransportShardMultiGetFomTranslogAction.Request(request, shardId);
            mgetFromTranslogRequest.setParentTask(request.getParentTask());
            this.transportService.sendRequest(node, "internal:data/read/mget_from_translog[shard]", mgetFromTranslogRequest, new ActionListenerResponseHandler<TransportShardMultiGetFomTranslogAction.Response>(listener.delegateFailure((l, r) -> {
                boolean responseHasMissingLocations = false;
                for (int i = 0; i < r.multiGetShardResponse().locations.size(); ++i) {
                    if (r.multiGetShardResponse().responses.get(i) != null || r.multiGetShardResponse().failures.get(i) != null) continue;
                    responseHasMissingLocations = true;
                    break;
                }
                if (!responseHasMissingLocations) {
                    logger.debug("received result of all ids in real-time mget[shard] from the promotable shard.");
                    l.onResponse(r.multiGetShardResponse());
                } else {
                    logger.debug("no result for some ids from the promotable shard (segment generation to wait for: {})", new Object[]{r.segmentGeneration()});
                    if (r.segmentGeneration() == -1L) {
                        ActionRunnable.supply(l, () -> this.handleLocalGets(request, r.multiGetShardResponse(), shardId)).run();
                    } else {
                        assert (r.segmentGeneration() > -1L);
                        assert (r.primaryTerm() > -1L);
                        indexShard.waitForPrimaryTermAndGeneration(r.primaryTerm(), r.segmentGeneration(), listener.delegateFailureAndWrap((ll, aLong) -> this.getExecutor(request, shardId).execute(ActionRunnable.supply(ll, () -> this.handleLocalGets(request, r.multiGetShardResponse(), shardId)))));
                    }
                }
            }), TransportShardMultiGetFomTranslogAction.Response::new, this.getExecutor(request, shardId)));
        } else {
            super.asyncShardOperation(request, shardId, listener);
        }
    }

    private MultiGetShardResponse handleLocalGets(MultiGetShardRequest request, MultiGetShardResponse response, ShardId shardId) {
        logger.trace("handling local gets for missing locations");
        for (int i = 0; i < response.locations.size(); ++i) {
            if (response.responses.get(i) != null || response.failures.get(i) != null) continue;
            this.getAndAddToResponse(shardId, i, request, response);
        }
        return response;
    }

    private void getAndAddToResponse(ShardId shardId, int location, MultiGetShardRequest request, MultiGetShardResponse response) {
        IndexShard indexShard = this.getIndexShard(shardId);
        MultiGetRequest.Item item = request.items.get(location);
        try {
            GetResult getResult = indexShard.getService().get(item.id(), item.storedFields(), request.realtime(), item.version(), item.versionType(), item.fetchSourceContext(), request.isForceSyntheticSource());
            response.add((int)request.locations.get(location), new GetResponse(getResult));
        }
        catch (RuntimeException e) {
            if (TransportActions.isShardNotAvailableException(e)) {
                throw e;
            }
            logger.debug(() -> Strings.format((String)"%s failed to execute multi_get for [%s]", (Object[])new Object[]{shardId, item.id()}), (Throwable)e);
            response.add((int)request.locations.get(location), new MultiGetResponse.Failure(request.index(), item.id(), e));
        }
        catch (IOException e) {
            logger.debug(() -> Strings.format((String)"%s failed to execute multi_get for [%s]", (Object[])new Object[]{shardId, item.id()}), (Throwable)e);
            response.add((int)request.locations.get(location), new MultiGetResponse.Failure(request.index(), item.id(), e));
        }
    }

    private void asyncShardMultiGet(MultiGetShardRequest request, ShardId shardId, ActionListener<MultiGetShardResponse> listener) throws IOException {
        if (request.refresh() && !request.realtime()) {
            this.getExecutor(request, shardId).execute(ActionRunnable.wrap(listener, l -> {
                IndexShard indexShard = this.getIndexShard(shardId);
                indexShard.externalRefresh("refresh_flag_mget", l.map(r -> this.shardOperation(request, shardId)));
            }));
        } else {
            super.asyncShardOperation(request, shardId, listener);
        }
    }

    private IndexShard getIndexShard(ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return indexService.getShard(shardId.id());
    }
}

