/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.refresh;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.refresh.ShardRefreshReplicaRequest;
import org.elasticsearch.action.admin.indices.refresh.TransportUnpromotableShardRefreshAction;
import org.elasticsearch.action.admin.indices.refresh.UnpromotableShardRefreshRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.BasicReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportShardRefreshAction
extends TransportReplicationAction<BasicReplicationRequest, ShardRefreshReplicaRequest, ReplicationResponse> {
    private static final Logger logger = LogManager.getLogger(TransportShardRefreshAction.class);
    public static final String NAME = "indices:admin/refresh[s]";
    public static final ActionType<ReplicationResponse> TYPE = new ActionType<ReplicationResponse>("indices:admin/refresh[s]", ReplicationResponse::new);
    public static final String SOURCE_API = "api";
    private final Executor refreshExecutor;

    @Inject
    public TransportShardRefreshAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters) {
        super(settings, NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, BasicReplicationRequest::new, ShardRefreshReplicaRequest::new, threadPool.executor("refresh"));
        new TransportUnpromotableShardRefreshAction(clusterService, transportService, shardStateAction, actionFilters, indicesService);
        this.refreshExecutor = transportService.getThreadPool().executor("refresh");
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    protected void shardOperationOnPrimary(BasicReplicationRequest shardRequest, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<ShardRefreshReplicaRequest, ReplicationResponse>> listener) {
        primary.externalRefresh(SOURCE_API, listener.safeMap(refreshResult -> {
            ShardRefreshReplicaRequest replicaRequest = new ShardRefreshReplicaRequest(shardRequest.shardId(), (Engine.RefreshResult)refreshResult);
            replicaRequest.setParentTask(shardRequest.getParentTask());
            logger.trace("{} refresh request executed on primary", new Object[]{primary.shardId()});
            return new TransportReplicationAction.PrimaryResult<ShardRefreshReplicaRequest, ReplicationResponse>(replicaRequest, new ReplicationResponse());
        }));
    }

    @Override
    protected void shardOperationOnReplica(ShardRefreshReplicaRequest request, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        replica.externalRefresh(SOURCE_API, listener.safeMap(refreshResult -> {
            logger.trace("{} refresh request executed on replica", new Object[]{replica.shardId()});
            return new TransportReplicationAction.ReplicaResult();
        }));
    }

    @Override
    protected ReplicationOperation.Replicas<ShardRefreshReplicaRequest> newReplicasProxy() {
        return new UnpromotableReplicasRefreshProxy();
    }

    protected class UnpromotableReplicasRefreshProxy
    extends TransportReplicationAction.ReplicasProxy {
        protected UnpromotableReplicasRefreshProxy() {
        }

        @Override
        public void onPrimaryOperationComplete(ShardRefreshReplicaRequest replicaRequest, IndexShardRoutingTable indexShardRoutingTable, ActionListener<Void> listener) {
            assert (replicaRequest.primaryRefreshResult.refreshed()) : "primary has not refreshed";
            boolean fastRefresh = IndexSettings.INDEX_FAST_REFRESH_SETTING.get(TransportShardRefreshAction.this.clusterService.state().metadata().index(indexShardRoutingTable.shardId().getIndex()).getSettings());
            if (fastRefresh) {
                listener.onResponse(null);
            } else {
                UnpromotableShardRefreshRequest unpromotableReplicaRequest = new UnpromotableShardRefreshRequest(indexShardRoutingTable, replicaRequest.primaryRefreshResult.primaryTerm(), replicaRequest.primaryRefreshResult.generation(), false);
                TransportShardRefreshAction.this.transportService.sendRequest(TransportShardRefreshAction.this.transportService.getLocalNode(), "indices:admin/refresh/unpromotable", unpromotableReplicaRequest, new ActionListenerResponseHandler<ActionResponse.Empty>(listener.safeMap(r -> null), in -> ActionResponse.Empty.INSTANCE, TransportShardRefreshAction.this.refreshExecutor));
            }
        }
    }
}

