/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.apmdata;

import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.xpack.apmdata.APMIndexTemplateRegistry;

public class APMPlugin
extends Plugin
implements ActionPlugin {
    private static final Logger logger = LogManager.getLogger(APMPlugin.class);
    private final SetOnce<APMIndexTemplateRegistry> registry = new SetOnce();

    public Collection<?> createComponents(Plugin.PluginServices services) {
        this.registry.set((Object)new APMIndexTemplateRegistry(services.environment().settings(), services.clusterService(), services.threadPool(), services.client(), services.xContentRegistry()));
        APMIndexTemplateRegistry registryInstance = (APMIndexTemplateRegistry)((Object)this.registry.get());
        logger.info("APM ingest plugin is {}", (Object)(registryInstance.isEnabled() ? "enabled" : "disabled"));
        registryInstance.initialize();
        return List.of(registryInstance);
    }

    public void close() {
        ((APMIndexTemplateRegistry)((Object)this.registry.get())).close();
    }
}

