/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.SplitSingleByteEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.SplitVariableEvaluator;
import org.elasticsearch.xpack.ql.InvalidArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Split
extends BinaryScalarFunction
implements EvaluatorMapper {
    public Split(Source source, Expression str, Expression delim) {
        super(source, str, delim);
    }

    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isStringAndExact((Expression)this.left(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isString((Expression)this.right(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
    }

    public boolean foldable() {
        return this.left().foldable() && this.right().foldable();
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    static void process(BytesRefBlock.Builder builder, BytesRef str, byte delim, BytesRef scratch) {
        scratch.bytes = str.bytes;
        scratch.offset = str.offset;
        int end = str.offset + str.length;
        for (int i = str.offset; i < end; ++i) {
            if (str.bytes[i] != delim) continue;
            scratch.length = i - scratch.offset;
            if (scratch.offset == str.offset) {
                builder.beginPositionEntry();
            }
            builder.appendBytesRef(scratch);
            scratch.offset = i + 1;
        }
        if (scratch.offset == str.offset) {
            builder.appendBytesRef(str);
            return;
        }
        scratch.length = str.length - (scratch.offset - str.offset);
        builder.appendBytesRef(scratch);
        builder.endPositionEntry();
    }

    static void process(BytesRefBlock.Builder builder, BytesRef str, BytesRef delim, BytesRef scratch) {
        Split.checkDelimiter(delim);
        Split.process(builder, str, delim.bytes[delim.offset], scratch);
    }

    protected BinaryScalarFunction replaceChildren(Expression newLeft, Expression newRight) {
        return new Split(this.source(), newLeft, newRight);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Split::new, (Object)this.left(), (Object)this.right());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory str = toEvaluator.apply(this.left());
        if (!this.right().foldable()) {
            return new SplitVariableEvaluator.Factory(this.source(), str, toEvaluator.apply(this.right()), context -> new BytesRef());
        }
        BytesRef delim = (BytesRef)this.right().fold();
        Split.checkDelimiter(delim);
        return new SplitSingleByteEvaluator.Factory(this.source(), str, delim.bytes[delim.offset], context -> new BytesRef());
    }

    private static void checkDelimiter(BytesRef delim) {
        if (delim.length != 1) {
            throw new InvalidArgumentException("delimiter must be single byte for now", new Object[0]);
        }
    }
}

