/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMin;

public final class MvMinBooleanEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    private final DriverContext driverContext;

    public MvMinBooleanEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(field);
        this.driverContext = driverContext;
    }

    @Override
    public String name() {
        return "MvMin";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNullable(fieldVal);
        }
        BooleanBlock v = (BooleanBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (BooleanBlock.Builder builder = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                boolean value = v.getBoolean(first);
                for (int i = first + 1; i < end; ++i) {
                    boolean next = v.getBoolean(i);
                    value = MvMin.process(value, next);
                }
                boolean result = value;
                builder.appendBoolean(result);
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNotNullable(fieldVal);
        }
        BooleanBlock v = (BooleanBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (BooleanVector.FixedBuilder builder = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                boolean value = v.getBoolean(first);
                for (int i = first + 1; i < end; ++i) {
                    boolean next = v.getBoolean(i);
                    value = MvMin.process(value, next);
                }
                boolean result = value;
                builder.appendBoolean(result);
            }
            BooleanBlock booleanBlock = builder.build().asBlock();
            return booleanBlock;
        }
    }

    private Block evalAscendingNullable(Block fieldVal) {
        BooleanBlock v = (BooleanBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (BooleanBlock.Builder builder = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int idx = MvMin.ascendingIndex(valueCount);
                boolean result = v.getBoolean(first + idx);
                builder.appendBoolean(result);
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    private Block evalAscendingNotNullable(Block fieldVal) {
        BooleanBlock v = (BooleanBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (BooleanVector.FixedBuilder builder = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int idx = MvMin.ascendingIndex(valueCount);
                boolean result = v.getBoolean(first + idx);
                builder.appendBoolean(result);
            }
            BooleanBlock booleanBlock = builder.build().asBlock();
            return booleanBlock;
        }
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvMinBooleanEvaluator get(DriverContext context) {
            return new MvMinBooleanEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvMin[field=" + this.field + "]";
        }
    }
}

