/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.util.List;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.MultivalueDedupe;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class MvDedupe
extends AbstractMultivalueFunction {
    @FunctionInfo(returnType={"?"}, description="Remove duplicate values from a multivalued field.")
    public MvDedupe(Source source, @Param(name="v", type={"boolean", "date", "double", "ip", "text", "integer", "keyword", "version", "long"}) Expression field) {
        super(source, field);
    }

    @Override
    protected Expression.TypeResolution resolveFieldType() {
        return TypeResolutions.isType((Expression)this.field(), EsqlDataTypes::isRepresentable, (String)this.sourceText(), null, (String[])new String[]{"representable"});
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEval) {
        return MultivalueDedupe.evaluator((ElementType)PlannerUtils.toElementType(this.dataType()), (EvalOperator.ExpressionEvaluator.Factory)fieldEval);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvDedupe(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvDedupe::new, (Object)this.field());
    }
}

