/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.IsFiniteEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RationalUnaryPredicate;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class IsFinite
extends RationalUnaryPredicate {
    @FunctionInfo(returnType={"boolean"}, description="Returns true if the argument is a finite floating-point value.")
    public IsFinite(Source source, @Param(name="n", type={"double"}, description="A floating-point value") Expression field) {
        super(source, field);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory field = toEvaluator.apply(this.field());
        return new IsFiniteEvaluator.Factory(this.source(), field);
    }

    static boolean process(double val) {
        return Double.isFinite(val);
    }

    public final Expression replaceChildren(List<Expression> newChildren) {
        return new IsFinite(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, IsFinite::new, (Object)this.field());
    }
}

