/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.ql.tree.Source;

public final class CastLongToUnsignedLongEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator v;
    private final DriverContext driverContext;

    public CastLongToUnsignedLongEvaluator(Source source, EvalOperator.ExpressionEvaluator v, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.v = v;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock vBlock = (LongBlock)this.v.eval(page);){
            LongVector vVector = vBlock.asVector();
            if (vVector == null) {
                LongBlock longBlock = this.eval(page.getPositionCount(), vBlock);
                return longBlock;
            }
            LongBlock longBlock = this.eval(page.getPositionCount(), vVector).asBlock();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, LongBlock vBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (vBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (vBlock.getValueCount(p) != 1) {
                    if (vBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendLong(Cast.castLongToUnsignedLong(vBlock.getLong(vBlock.getFirstValueIndex(p))));
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongVector eval(int positionCount, LongVector vVector) {
        try (LongVector.Builder result = this.driverContext.blockFactory().newLongVectorBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendLong(Cast.castLongToUnsignedLong(vVector.getLong(p)));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "CastLongToUnsignedLongEvaluator[v=" + this.v + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.v);
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory v;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory v) {
            this.source = source;
            this.v = v;
        }

        public CastLongToUnsignedLongEvaluator get(DriverContext context) {
            return new CastLongToUnsignedLongEvaluator(this.source, this.v.get(context), context);
        }

        public String toString() {
            return "CastLongToUnsignedLongEvaluator[v=" + this.v + "]";
        }
    }
}

