/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar;

import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;

public abstract class UnaryScalarFunction
extends ScalarFunction {
    protected final Expression field;

    public UnaryScalarFunction(Source source, Expression field) {
        super(source, Arrays.asList(field));
        this.field = field;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isNumeric((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public boolean foldable() {
        return this.field.foldable();
    }

    public final Expression field() {
        return this.field;
    }

    public DataType dataType() {
        return this.field.dataType();
    }

    public final int hashCode() {
        return Objects.hash(this.field);
    }

    public final boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        UnaryScalarFunction other = (UnaryScalarFunction)((Object)obj);
        return Objects.equals(other.field, this.field);
    }

    public final ScriptTemplate asScript() {
        throw new UnsupportedOperationException("functions do not support scripting");
    }
}

