/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.execution;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.analysis.PreAnalyzer;
import org.elasticsearch.xpack.esql.analysis.Verifier;
import org.elasticsearch.xpack.esql.enrich.EnrichPolicyResolver;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.Mapper;
import org.elasticsearch.xpack.esql.session.EsqlConfiguration;
import org.elasticsearch.xpack.esql.session.EsqlSession;
import org.elasticsearch.xpack.esql.stats.Metrics;
import org.elasticsearch.xpack.esql.stats.QueryMetric;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.index.IndexResolver;

public class PlanExecutor {
    private final IndexResolver indexResolver;
    private final PreAnalyzer preAnalyzer;
    private final FunctionRegistry functionRegistry;
    private final Mapper mapper;
    private final Metrics metrics;
    private final Verifier verifier;

    public PlanExecutor(IndexResolver indexResolver) {
        this.indexResolver = indexResolver;
        this.preAnalyzer = new PreAnalyzer();
        this.functionRegistry = new EsqlFunctionRegistry();
        this.mapper = new Mapper(this.functionRegistry);
        this.metrics = new Metrics();
        this.verifier = new Verifier(this.metrics);
    }

    public void esql(EsqlQueryRequest request, String sessionId, EsqlConfiguration cfg, EnrichPolicyResolver enrichPolicyResolver, ActionListener<PhysicalPlan> listener) {
        EsqlSession session = new EsqlSession(sessionId, cfg, this.indexResolver, enrichPolicyResolver, this.preAnalyzer, this.functionRegistry, new LogicalPlanOptimizer(new LogicalOptimizerContext(cfg)), this.mapper, this.verifier);
        QueryMetric clientId = QueryMetric.fromString("rest");
        this.metrics.total(clientId);
        session.execute(request, (ActionListener<PhysicalPlan>)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), ex -> {
            this.metrics.failed(clientId);
            listener.onFailure(ex);
        }));
    }

    public IndexResolver indexResolver() {
        return this.indexResolver;
    }

    public Metrics metrics() {
        return this.metrics;
    }
}

