/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMedian;

public final class MvMedianIntEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    private final DriverContext driverContext;

    public MvMedianIntEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(field);
        this.driverContext = driverContext;
    }

    @Override
    public String name() {
        return "MvMedian";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNullable(fieldVal);
        }
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntBlock.Builder builder = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            MvMedian.Ints work = new MvMedian.Ints();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                for (int i = first; i < end; ++i) {
                    int value = v.getInt(i);
                    MvMedian.process(work, value);
                }
                int result = MvMedian.finish(work);
                builder.appendInt(result);
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNotNullable(fieldVal);
        }
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntVector.FixedBuilder builder = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            MvMedian.Ints work = new MvMedian.Ints();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                for (int i = first; i < end; ++i) {
                    int value = v.getInt(i);
                    MvMedian.process(work, value);
                }
                int result = MvMedian.finish(work);
                builder.appendInt(result);
            }
            IntBlock intBlock = builder.build().asBlock();
            return intBlock;
        }
    }

    private Block evalAscendingNullable(Block fieldVal) {
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntBlock.Builder builder = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            MvMedian.Ints work = new MvMedian.Ints();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int result = MvMedian.ascending(v, first, valueCount);
                builder.appendInt(result);
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    private Block evalAscendingNotNullable(Block fieldVal) {
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntVector.FixedBuilder builder = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            MvMedian.Ints work = new MvMedian.Ints();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int result = MvMedian.ascending(v, first, valueCount);
                builder.appendInt(result);
            }
            IntBlock intBlock = builder.build().asBlock();
            return intBlock;
        }
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvMedianIntEvaluator get(DriverContext context) {
            return new MvMedianIntEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvMedian[field=" + this.field + "]";
        }
    }
}

