/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.util.List;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class MvCount
extends AbstractMultivalueFunction {
    @FunctionInfo(returnType={"integer"}, description="Reduce a multivalued field to a single valued field containing the count of values.")
    public MvCount(Source source, @Param(name="v", type={"unsigned_long", "date", "boolean", "double", "ip", "text", "integer", "keyword", "version", "long", "geo_point", "cartesian_point"}) Expression v) {
        super(source, v);
    }

    @Override
    protected Expression.TypeResolution resolveFieldType() {
        return TypeResolutions.isType((Expression)this.field(), EsqlDataTypes::isRepresentable, (String)this.sourceText(), null, (String[])new String[]{"representable"});
    }

    @Override
    public DataType dataType() {
        return DataTypes.INTEGER;
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEval) {
        return new EvaluatorFactory(fieldEval);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvCount(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvCount::new, (Object)this.field());
    }

    private record EvaluatorFactory(EvalOperator.ExpressionEvaluator.Factory field) implements EvalOperator.ExpressionEvaluator.Factory
    {
        public EvalOperator.ExpressionEvaluator get(DriverContext context) {
            return new Evaluator(context, this.field.get(context));
        }

        @Override
        public String toString() {
            return "MvCount[field=" + this.field + "]";
        }
    }

    private static class Evaluator
    extends AbstractMultivalueFunction.AbstractEvaluator {
        private final DriverContext driverContext;

        protected Evaluator(DriverContext driverContext, EvalOperator.ExpressionEvaluator field) {
            super(field);
            this.driverContext = driverContext;
        }

        @Override
        protected String name() {
            return "MvCount";
        }

        @Override
        protected Block evalNullable(Block block) {
            try (IntBlock.Builder builder = IntBlock.newBlockBuilder((int)block.getPositionCount(), (BlockFactory)this.driverContext.blockFactory());){
                for (int p = 0; p < block.getPositionCount(); ++p) {
                    int valueCount = block.getValueCount(p);
                    if (valueCount == 0) {
                        builder.appendNull();
                        continue;
                    }
                    builder.appendInt(valueCount);
                }
                IntBlock intBlock = builder.build();
                return intBlock;
            }
        }

        @Override
        protected Block evalNotNullable(Block block) {
            try (IntVector.FixedBuilder builder = IntVector.newVectorFixedBuilder((int)block.getPositionCount(), (BlockFactory)this.driverContext.blockFactory());){
                for (int p = 0; p < block.getPositionCount(); ++p) {
                    builder.appendInt(block.getValueCount(p));
                }
                IntBlock intBlock = builder.build().asBlock();
                return intBlock;
            }
        }

        @Override
        protected Block evalSingleValuedNullable(Block ref) {
            return this.evalNullable(ref);
        }

        @Override
        protected Block evalSingleValuedNotNullable(Block ref) {
            return this.driverContext.blockFactory().newConstantIntBlockWith(1, ref.getPositionCount());
        }
    }
}

