/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.List;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.AbstractTrigonometricFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.SinhEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class Sinh
extends AbstractTrigonometricFunction {
    @FunctionInfo(returnType={"double"})
    public Sinh(Source source, @Param(name="n", type={"integer", "long", "double", "unsigned_long"}) Expression n) {
        super(source, n);
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory doubleEvaluator(EvalOperator.ExpressionEvaluator.Factory field) {
        return new SinhEvaluator.Factory(this.source(), field);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Sinh(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Sinh::new, (Object)this.field());
    }

    static double process(double val) {
        double res = Math.sinh(val);
        if (Double.isNaN(res) || Double.isInfinite(res)) {
            throw new ArithmeticException("sinh overflow");
        }
        return res;
    }
}

