/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDatetimeFromStringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateParse;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class ToDatetime
extends AbstractConvertFunction {
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataTypes.DATETIME, (field, source) -> field), Map.entry(DataTypes.LONG, (field, source) -> field), Map.entry(DataTypes.KEYWORD, ToDatetimeFromStringEvaluator.Factory::new), Map.entry(DataTypes.TEXT, ToDatetimeFromStringEvaluator.Factory::new), Map.entry(DataTypes.DOUBLE, ToLongFromDoubleEvaluator.Factory::new), Map.entry(DataTypes.UNSIGNED_LONG, ToLongFromUnsignedLongEvaluator.Factory::new), Map.entry(DataTypes.INTEGER, ToLongFromIntEvaluator.Factory::new));

    @FunctionInfo(returnType={"date"})
    public ToDatetime(Source source, @Param(name="v", type={"date", "keyword", "text", "double", "long", "unsigned_long", "integer"}) Expression field) {
        super(source, field);
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataTypes.DATETIME;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToDatetime(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToDatetime::new, (Object)this.field());
    }

    static long fromKeyword(BytesRef in) {
        return DateParse.process(in, DateParse.DEFAULT_FORMATTER);
    }
}

