/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression;

import java.util.Locale;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.EsField;

public class EsqlTypeResolutions {
    public static Expression.TypeResolution isExact(Expression e, String operationName, TypeResolutions.ParamOrdinal paramOrd) {
        if (e instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)e;
            if (DataTypes.isString((DataType)fa.dataType())) {
                return Expression.TypeResolution.TYPE_RESOLVED;
            }
            EsField.Exact exact = fa.getExactInfo();
            if (!exact.hasExact()) {
                return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"[{}] cannot operate on {}field of data type [{}]: {}", (Object[])new Object[]{operationName, paramOrd == null || paramOrd == TypeResolutions.ParamOrdinal.DEFAULT ? "" : paramOrd.name().toLowerCase(Locale.ROOT) + " argument ", e.dataType().typeName(), exact.errorMsg()}));
            }
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }
}

