/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.util.Arrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class MergePositionsOperator
implements Operator {
    private boolean finished = false;
    private int filledPositions = 0;
    private final boolean singleMode;
    private final int positionCount;
    private final int positionChannel;
    private final Block.Builder[] outputBuilders;
    private final int[] mergingChannels;
    private final ElementType[] mergingTypes;
    private PositionBuilder positionBuilder = null;
    private Page outputPage;
    private final BlockFactory blockFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MergePositionsOperator(boolean singleMode, int positionCount, int positionChannel, int[] mergingChannels, ElementType[] mergingTypes, BlockFactory blockFactory) {
        if (mergingChannels.length != mergingTypes.length) {
            throw new IllegalArgumentException("Merging channels don't match merging types; channels=" + Arrays.toString(mergingChannels) + ",types=" + Arrays.toString(mergingTypes));
        }
        this.blockFactory = blockFactory;
        this.singleMode = singleMode;
        this.positionCount = positionCount;
        this.positionChannel = positionChannel;
        this.mergingChannels = mergingChannels;
        this.mergingTypes = mergingTypes;
        this.outputBuilders = new Block.Builder[mergingTypes.length];
        try {
            for (int i = 0; i < mergingTypes.length; ++i) {
                this.outputBuilders[i] = mergingTypes[i].newBlockBuilder(positionCount, blockFactory);
            }
        }
        finally {
            if (this.outputBuilders[this.outputBuilders.length - 1] == null) {
                Releasables.close((Releasable[])this.outputBuilders);
            }
        }
    }

    public boolean needsInput() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInput(Page page) {
        block6: {
            try {
                IntBlock positions = (IntBlock)page.getBlock(this.positionChannel);
                int currentPosition = positions.getInt(0);
                if (this.singleMode) {
                    this.fillNullUpToPosition(currentPosition);
                    for (int i = 0; i < this.mergingChannels.length; ++i) {
                        int channel = this.mergingChannels[i];
                        this.outputBuilders[i].appendAllValuesToCurrentPosition(page.getBlock(channel));
                    }
                    ++this.filledPositions;
                    break block6;
                }
                if (this.positionBuilder != null && this.positionBuilder.position != currentPosition) {
                    this.flushPositionBuilder();
                }
                if (this.positionBuilder == null) {
                    this.positionBuilder = new PositionBuilder(currentPosition, this.mergingTypes, this.blockFactory);
                }
                this.positionBuilder.combine(page, this.mergingChannels);
            }
            catch (Throwable throwable) {
                Releasables.closeExpectNoException(() -> ((Page)page).releaseBlocks());
                throw throwable;
            }
        }
        Releasables.closeExpectNoException(() -> ((Page)page).releaseBlocks());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPositionBuilder() {
        this.fillNullUpToPosition(this.positionBuilder.position);
        ++this.filledPositions;
        try (PositionBuilder p = this.positionBuilder;){
            p.buildTo(this.outputBuilders);
        }
        finally {
            this.positionBuilder = null;
        }
    }

    private void fillNullUpToPosition(int position) {
        while (this.filledPositions < position) {
            for (Block.Builder builder : this.outputBuilders) {
                builder.appendNull();
            }
            ++this.filledPositions;
        }
    }

    public void finish() {
        if (this.positionBuilder != null) {
            this.flushPositionBuilder();
        }
        this.fillNullUpToPosition(this.positionCount);
        Block[] blocks = Block.Builder.buildAll((Block.Builder[])this.outputBuilders);
        this.outputPage = new Page(blocks);
        assert (this.outputPage.getPositionCount() == this.positionCount);
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished && this.outputPage == null;
    }

    public Page getOutput() {
        Page page = this.outputPage;
        this.outputPage = null;
        return page;
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{Releasables.wrap((Releasable[])this.outputBuilders), this.positionBuilder, () -> {
            if (this.outputPage != null) {
                this.outputPage.releaseBlocks();
            }
        }});
    }

    static final class PositionBuilder
    implements Releasable {
        private final int position;
        private final Block.Builder[] builders;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PositionBuilder(int position, ElementType[] elementTypes, BlockFactory blockFactory) {
            this.position = position;
            this.builders = new Block.Builder[elementTypes.length];
            try {
                for (int i = 0; i < this.builders.length; ++i) {
                    this.builders[i] = elementTypes[i].newBlockBuilder(1, blockFactory);
                }
            }
            finally {
                if (this.builders[this.builders.length - 1] == null) {
                    Releasables.close((Releasable[])this.builders);
                }
            }
        }

        void combine(Page page, int[] channels) {
            for (int i = 0; i < channels.length; ++i) {
                Block block = page.getBlock(channels[i]);
                this.builders[i].appendAllValuesToCurrentPosition(block);
            }
        }

        void buildTo(Block.Builder[] output) {
            for (int i = 0; i < output.length; ++i) {
                try (Block.Builder b = this.builders[i];
                     Block block = b.build();){
                    output[i].appendAllValuesToCurrentPosition(block);
                    continue;
                }
            }
        }

        public void close() {
            Releasables.close((Releasable[])this.builders);
        }
    }
}

