/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.UnsupportedValueSource;
import org.elasticsearch.compute.operator.DriverProfile;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.InstantiatingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.action.ColumnInfo;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.util.DateUtils;
import org.elasticsearch.xpack.ql.util.NumericUtils;
import org.elasticsearch.xpack.ql.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.ql.util.StringUtils;
import org.elasticsearch.xpack.versionfield.Version;

public class EsqlQueryResponse
extends ActionResponse
implements ChunkedToXContentObject,
Releasable {
    private static final InstantiatingObjectParser<EsqlQueryResponse, Void> PARSER;
    private final List<ColumnInfo> columns;
    private final List<Page> pages;
    private final Profile profile;
    private final boolean columnar;

    public EsqlQueryResponse(List<ColumnInfo> columns, List<Page> pages, @Nullable Profile profile, boolean columnar) {
        this.columns = columns;
        this.pages = pages;
        this.profile = profile;
        this.columnar = columnar;
    }

    public EsqlQueryResponse(List<ColumnInfo> columns, List<List<Object>> values) {
        this.columns = columns;
        this.pages = List.of(EsqlQueryResponse.valuesToPage(columns.stream().map(ColumnInfo::type).toList(), values));
        this.profile = null;
        this.columnar = false;
    }

    public static Writeable.Reader<EsqlQueryResponse> reader(BlockFactory blockFactory) {
        return in -> new EsqlQueryResponse(new BlockStreamInput(in, blockFactory));
    }

    private EsqlQueryResponse(BlockStreamInput in) throws IOException {
        super((StreamInput)in);
        this.columns = in.readCollectionAsList(ColumnInfo::new);
        this.pages = in.readCollectionAsList(Page::new);
        this.profile = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_PROFILE) ? (Profile)in.readOptionalWriteable(Profile::new) : null;
        this.columnar = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.columns);
        out.writeCollection(this.pages);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_PROFILE)) {
            out.writeOptionalWriteable((Writeable)this.profile);
        }
        out.writeBoolean(this.columnar);
    }

    public List<ColumnInfo> columns() {
        return this.columns;
    }

    List<Page> pages() {
        return this.pages;
    }

    public Iterator<Iterator<Object>> values() {
        return EsqlQueryResponse.pagesToValues(this.columns.stream().map(ColumnInfo::type).toList(), this.pages);
    }

    public Profile profile() {
        return this.profile;
    }

    public boolean columnar() {
        return this.columnar;
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        BytesRef scratch = new BytesRef();
        Iterator valuesIt = this.pages.isEmpty() ? Collections.emptyIterator() : (this.columnar ? Iterators.flatMap((Iterator)Iterators.forRange((int)0, (int)this.columns().size(), column -> Iterators.concat((Iterator[])new Iterator[]{Iterators.single((builder, p) -> builder.startArray()), Iterators.flatMap(this.pages.iterator(), page -> {
            ColumnInfo.PositionToXContent toXContent = this.columns.get(column).positionToXContent(page.getBlock(column), scratch);
            return Iterators.forRange((int)0, (int)page.getPositionCount(), position -> (builder, p) -> toXContent.positionToXContent(builder, p, position));
        }), ChunkedToXContentHelper.endArray()})), Function.identity()) : Iterators.flatMap(this.pages.iterator(), page -> {
            int columnCount = this.columns.size();
            assert (page.getBlockCount() == columnCount) : page.getBlockCount() + " != " + columnCount;
            ColumnInfo.PositionToXContent[] toXContents = new ColumnInfo.PositionToXContent[columnCount];
            for (int column = 0; column < columnCount; ++column) {
                toXContents[column] = this.columns.get(column).positionToXContent(page.getBlock(column), scratch);
            }
            return Iterators.forRange((int)0, (int)page.getPositionCount(), position -> (builder, p) -> {
                builder.startArray();
                for (int c = 0; c < columnCount; ++c) {
                    toXContents[c].positionToXContent(builder, p, position);
                }
                return builder.endArray();
            });
        }));
        Iterator columnsRender = ChunkedToXContentHelper.singleChunk((ToXContent[])new ToXContent[]{(builder, p) -> {
            builder.startArray("columns");
            for (ColumnInfo col : this.columns) {
                col.toXContent(builder, p);
            }
            return builder.endArray();
        }});
        Iterator profileRender = this.profile == null ? List.of().iterator() : ChunkedToXContentHelper.field((String)"profile", (ChunkedToXContentObject)this.profile, (ToXContent.Params)params);
        return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), columnsRender, ChunkedToXContentHelper.array((String)"values", (Iterator)valuesIt), profileRender, ChunkedToXContentHelper.endObject()});
    }

    public boolean isFragment() {
        return false;
    }

    public static EsqlQueryResponse fromXContent(XContentParser parser) {
        return (EsqlQueryResponse)((Object)PARSER.apply(parser, null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EsqlQueryResponse that = (EsqlQueryResponse)((Object)o);
        return Objects.equals(this.columns, that.columns) && this.columnar == that.columnar && Iterators.equals(this.values(), that.values(), (row1, row2) -> Iterators.equals((Iterator)row1, (Iterator)row2, Objects::equals)) && Objects.equals(this.profile, that.profile);
    }

    public int hashCode() {
        return Objects.hash(this.columns, Iterators.hashCode(this.values(), row -> Iterators.hashCode((Iterator)row, Objects::hashCode)), this.columnar);
    }

    public String toString() {
        return Strings.toString((ToXContent)ChunkedToXContent.wrapAsToXContent((ChunkedToXContent)this));
    }

    public void close() {
        Releasables.close(() -> Iterators.map(this.pages.iterator(), p -> () -> ((Page)p).releaseBlocks()));
    }

    public static Iterator<Iterator<Object>> pagesToValues(List<String> dataTypes, List<Page> pages) {
        BytesRef scratch = new BytesRef();
        return Iterators.flatMap(pages.iterator(), page -> Iterators.forRange((int)0, (int)page.getPositionCount(), p -> Iterators.forRange((int)0, (int)page.getBlockCount(), b -> {
            Block block = page.getBlock(b);
            if (block.isNull(p)) {
                return null;
            }
            int count = block.getValueCount(p);
            int start = block.getFirstValueIndex(p);
            String dataType = (String)dataTypes.get(b);
            if (count == 1) {
                return EsqlQueryResponse.valueAt(dataType, block, start, scratch);
            }
            ArrayList<Object> thisResult = new ArrayList<Object>(count);
            int end = count + start;
            for (int i = start; i < end; ++i) {
                thisResult.add(EsqlQueryResponse.valueAt(dataType, block, i, scratch));
            }
            return thisResult;
        })));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object valueAt(String dataType, Block block, int offset, BytesRef scratch) {
        switch (dataType) {
            case "unsigned_long": {
                Number number = NumericUtils.unsignedLongAsNumber((long)((LongBlock)block).getLong(offset));
                Object object = number;
                return object;
            }
            case "long": {
                Long l = ((LongBlock)block).getLong(offset);
                Object object = l;
                return object;
            }
            case "integer": {
                Integer n = ((IntBlock)block).getInt(offset);
                Object object = n;
                return object;
            }
            case "double": {
                Double d = ((DoubleBlock)block).getDouble(offset);
                Object object = d;
                return object;
            }
            case "keyword": 
            case "text": {
                String string = ((BytesRefBlock)block).getBytesRef(offset, scratch).utf8ToString();
                Object object = string;
                return object;
            }
            case "ip": {
                BytesRef val = ((BytesRefBlock)block).getBytesRef(offset, scratch);
                String string = DocValueFormat.IP.format(val);
                Object object = string;
                return object;
            }
            case "date": {
                long longVal = ((LongBlock)block).getLong(offset);
                String string = DateUtils.UTC_DATE_TIME_FORMATTER.formatMillis(longVal);
                Object object = string;
                return object;
            }
            case "boolean": {
                Boolean bl = ((BooleanBlock)block).getBoolean(offset);
                Object object = bl;
                return object;
            }
            case "version": {
                String string = new Version(((BytesRefBlock)block).getBytesRef(offset, scratch)).toString();
                Object object = string;
                return object;
            }
            case "geo_point": {
                SpatialPoint spatialPoint = SpatialCoordinateTypes.GEO.longAsPoint(((LongBlock)block).getLong(offset));
                Object object = spatialPoint;
                return object;
            }
            case "cartesian_point": {
                SpatialPoint spatialPoint = SpatialCoordinateTypes.CARTESIAN.longAsPoint(((LongBlock)block).getLong(offset));
                Object object = spatialPoint;
                return object;
            }
            case "unsupported": {
                String string = UnsupportedValueSource.UNSUPPORTED_OUTPUT;
                Object object = string;
                return object;
            }
            case "_source": {
                Object object;
                BytesRef val = ((BytesRefBlock)block).getBytesRef(offset, scratch);
                try (XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)new BytesArray(val));){
                    parser.nextToken();
                    Map map = parser.mapOrdered();
                    object = map;
                    return object;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        throw EsqlIllegalArgumentException.illegalDataType(dataType);
    }

    private static Page valuesToPage(List<String> dataTypes, List<List<Object>> values) {
        List<Block.Builder> results = dataTypes.stream().map(c -> PlannerUtils.toElementType(EsqlDataTypes.fromName(c)).newBlockBuilder(values.size())).toList();
        for (List<Object> row : values) {
            block40: for (int c2 = 0; c2 < row.size(); ++c2) {
                Block.Builder builder = results.get(c2);
                Object value = row.get(c2);
                switch (dataTypes.get(c2)) {
                    case "unsigned_long": {
                        ((LongBlock.Builder)builder).appendLong(NumericUtils.asLongUnsigned((long)((Number)value).longValue()));
                        continue block40;
                    }
                    case "long": {
                        ((LongBlock.Builder)builder).appendLong(((Number)value).longValue());
                        continue block40;
                    }
                    case "integer": {
                        ((IntBlock.Builder)builder).appendInt(((Number)value).intValue());
                        continue block40;
                    }
                    case "double": {
                        ((DoubleBlock.Builder)builder).appendDouble(((Number)value).doubleValue());
                        continue block40;
                    }
                    case "keyword": 
                    case "text": 
                    case "unsupported": {
                        ((BytesRefBlock.Builder)builder).appendBytesRef(new BytesRef((CharSequence)value.toString()));
                        continue block40;
                    }
                    case "ip": {
                        ((BytesRefBlock.Builder)builder).appendBytesRef(StringUtils.parseIP((String)value.toString()));
                        continue block40;
                    }
                    case "date": {
                        long longVal = DateUtils.UTC_DATE_TIME_FORMATTER.parseMillis(value.toString());
                        ((LongBlock.Builder)builder).appendLong(longVal);
                        continue block40;
                    }
                    case "boolean": {
                        ((BooleanBlock.Builder)builder).appendBoolean(((Boolean)value).booleanValue());
                        continue block40;
                    }
                    case "null": {
                        builder.appendNull();
                        continue block40;
                    }
                    case "version": {
                        ((BytesRefBlock.Builder)builder).appendBytesRef(new Version(value.toString()).toBytesRef());
                        continue block40;
                    }
                    case "_source": {
                        Map o = (Map)value;
                        try (XContentBuilder sourceBuilder = JsonXContent.contentBuilder();){
                            sourceBuilder.map(o);
                            ((BytesRefBlock.Builder)builder).appendBytesRef(BytesReference.bytes((XContentBuilder)sourceBuilder).toBytesRef());
                            continue block40;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    case "geo_point": {
                        long longVal = SpatialCoordinateTypes.GEO.pointAsLong(SpatialCoordinateTypes.GEO.stringAsPoint(value.toString()));
                        ((LongBlock.Builder)builder).appendLong(longVal);
                        continue block40;
                    }
                    case "cartesian_point": {
                        long longVal = SpatialCoordinateTypes.CARTESIAN.pointAsLong(SpatialCoordinateTypes.CARTESIAN.stringAsPoint(value.toString()));
                        ((LongBlock.Builder)builder).appendLong(longVal);
                        continue block40;
                    }
                    default: {
                        throw EsqlIllegalArgumentException.illegalDataType(dataTypes.get(c2));
                    }
                }
            }
        }
        return new Page((Block[])results.stream().map(Block.Builder::build).toArray(Block[]::new));
    }

    static {
        InstantiatingObjectParser.Builder parser = InstantiatingObjectParser.builder((String)"esql/query_response", (boolean)true, EsqlQueryResponse.class);
        parser.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> ColumnInfo.fromXContent(p), new ParseField("columns", new String[0]));
        parser.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.list(), new ParseField("values", new String[0]), ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER = parser.build();
    }

    public static class Profile
    implements Writeable,
    ChunkedToXContentObject {
        private final List<DriverProfile> drivers;

        public Profile(List<DriverProfile> drivers) {
            this.drivers = drivers;
        }

        public Profile(StreamInput in) throws IOException {
            this.drivers = in.readCollectionAsImmutableList(DriverProfile::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.drivers);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Profile profile = (Profile)o;
            return Objects.equals(this.drivers, profile.drivers);
        }

        public int hashCode() {
            return Objects.hash(this.drivers);
        }

        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), ChunkedToXContentHelper.array((String)"drivers", this.drivers.iterator(), (ToXContent.Params)params), ChunkedToXContentHelper.endObject()});
        }

        List<DriverProfile> drivers() {
            return this.drivers;
        }
    }
}

