/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.filtering;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.filtering.FilteringPolicy;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRuleCondition;

public class FilteringRule
implements Writeable,
ToXContentObject {
    private final Instant createdAt;
    private final String field;
    private final String id;
    private final Integer order;
    private final FilteringPolicy policy;
    private final FilteringRuleCondition rule;
    private final Instant updatedAt;
    private final String value;
    private static final ParseField CREATED_AT_FIELD = new ParseField("created_at", new String[0]);
    private static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    private static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    private static final ParseField ORDER_FIELD = new ParseField("order", new String[0]);
    private static final ParseField POLICY_FIELD = new ParseField("policy", new String[0]);
    private static final ParseField RULE_FIELD = new ParseField("rule", new String[0]);
    private static final ParseField UPDATED_AT_FIELD = new ParseField("updated_at", new String[0]);
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    private static final ConstructingObjectParser<FilteringRule, Void> PARSER = new ConstructingObjectParser("connector_filtering_rule", true, args -> new Builder().setCreatedAt((Instant)args[0]).setField((String)args[1]).setId((String)args[2]).setOrder((Integer)args[3]).setPolicy((FilteringPolicy)((Object)((Object)args[4]))).setRule((FilteringRuleCondition)((Object)((Object)args[5]))).setUpdatedAt((Instant)args[6]).setValue((String)args[7]).build());

    public FilteringRule(Instant createdAt, String field, String id, Integer order, FilteringPolicy policy, FilteringRuleCondition rule, Instant updatedAt, String value) {
        this.createdAt = createdAt;
        this.field = field;
        this.id = id;
        this.order = order;
        this.policy = policy;
        this.rule = rule;
        this.updatedAt = updatedAt;
        this.value = value;
    }

    public FilteringRule(StreamInput in) throws IOException {
        this.createdAt = in.readInstant();
        this.field = in.readString();
        this.id = in.readString();
        this.order = in.readInt();
        this.policy = (FilteringPolicy)in.readEnum(FilteringPolicy.class);
        this.rule = (FilteringRuleCondition)in.readEnum(FilteringRuleCondition.class);
        this.updatedAt = in.readInstant();
        this.value = in.readString();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(CREATED_AT_FIELD.getPreferredName(), (Object)this.createdAt);
        builder.field(FIELD_FIELD.getPreferredName(), this.field);
        builder.field(ID_FIELD.getPreferredName(), this.id);
        builder.field(ORDER_FIELD.getPreferredName(), this.order);
        builder.field(POLICY_FIELD.getPreferredName(), this.policy.toString());
        builder.field(RULE_FIELD.getPreferredName(), this.rule.toString());
        builder.field(UPDATED_AT_FIELD.getPreferredName(), (Object)this.updatedAt);
        builder.field(VALUE_FIELD.getPreferredName(), this.value);
        builder.endObject();
        return builder;
    }

    public static FilteringRule fromXContent(XContentParser parser) throws IOException {
        return (FilteringRule)PARSER.parse(parser, null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInstant(this.createdAt);
        out.writeString(this.field);
        out.writeString(this.id);
        out.writeInt(this.order.intValue());
        out.writeEnum((Enum)this.policy);
        out.writeEnum((Enum)this.rule);
        out.writeInstant(this.updatedAt);
        out.writeString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteringRule that = (FilteringRule)o;
        return Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.field, that.field) && Objects.equals(this.id, that.id) && Objects.equals(this.order, that.order) && this.policy == that.policy && this.rule == that.rule && Objects.equals(this.updatedAt, that.updatedAt) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.field, this.id, this.order, this.policy, this.rule, this.updatedAt, this.value});
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> Instant.parse(p.text()), CREATED_AT_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID_FIELD);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), ORDER_FIELD);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> FilteringPolicy.filteringPolicy(p.text()), POLICY_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> FilteringRuleCondition.filteringRuleCondition(p.text()), RULE_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> Instant.parse(p.text()), UPDATED_AT_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), VALUE_FIELD);
    }

    public static class Builder {
        private Instant createdAt;
        private String field;
        private String id;
        private Integer order;
        private FilteringPolicy policy;
        private FilteringRuleCondition rule;
        private Instant updatedAt;
        private String value;

        public Builder setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setOrder(Integer order) {
            this.order = order;
            return this;
        }

        public Builder setPolicy(FilteringPolicy policy) {
            this.policy = policy;
            return this;
        }

        public Builder setRule(FilteringRuleCondition rule) {
            this.rule = rule;
            return this;
        }

        public Builder setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public FilteringRule build() {
            return new FilteringRule(this.createdAt, this.field, this.id, this.order, this.policy, this.rule, this.updatedAt, this.value);
        }
    }
}

